/* ========================================================================= *
 *                                                                           *
 *                 The Apache Software License,  Version 1.1                 *
 *                                                                           *
 *         Copyright (c) 1999, 2000  The Apache Software Foundation.         *
 *                           All rights reserved.                            *
 *                                                                           *
 * ========================================================================= *
 *                                                                           *
 * Redistribution and use in source and binary forms,  with or without modi- *
 * fication, are permitted provided that the following conditions are met:   *
 *                                                                           *
 * 1. Redistributions of source code  must retain the above copyright notice *
 *    notice, this list of conditions and the following disclaimer.          *
 *                                                                           *
 * 2. Redistributions  in binary  form  must  reproduce the  above copyright *
 *    notice,  this list of conditions  and the following  disclaimer in the *
 *    documentation and/or other materials provided with the distribution.   *
 *                                                                           *
 * 3. The end-user documentation  included with the redistribution,  if any, *
 *    must include the following acknowlegement:                             *
 *                                                                           *
 *       "This product includes  software developed  by the Apache  Software *
 *        Foundation <http://www.apache.org/>."                              *
 *                                                                           *
 *    Alternately, this acknowlegement may appear in the software itself, if *
 *    and wherever such third-party acknowlegements normally appear.         *
 *                                                                           *
 * 4. The names  "The  Jakarta  Project",  "Tomcat",  and  "Apache  Software *
 *    Foundation"  must not be used  to endorse or promote  products derived *
 *    from this  software without  prior  written  permission.  For  written *
 *    permission, please contact <apache@apache.org>.                        *
 *                                                                           *
 * 5. Products derived from this software may not be called "Apache" nor may *
 *    "Apache" appear in their names without prior written permission of the *
 *    Apache Software Foundation.                                            *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES *
 * INCLUDING, BUT NOT LIMITED TO,  THE IMPLIED WARRANTIES OF MERCHANTABILITY *
 * AND FITNESS FOR  A PARTICULAR PURPOSE  ARE DISCLAIMED.  IN NO EVENT SHALL *
 * THE APACHE  SOFTWARE  FOUNDATION OR  ITS CONTRIBUTORS  BE LIABLE  FOR ANY *
 * DIRECT,  INDIRECT,   INCIDENTAL,  SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL *
 * DAMAGES (INCLUDING,  BUT NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE GOODS *
 * OR SERVICES;  LOSS OF USE,  DATA,  OR PROFITS;  OR BUSINESS INTERRUPTION) *
 * HOWEVER CAUSED AND  ON ANY  THEORY  OF  LIABILITY,  WHETHER IN  CONTRACT, *
 * STRICT LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN *
 * ANY  WAY  OUT OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF  ADVISED  OF THE *
 * POSSIBILITY OF SUCH DAMAGE.                                               *
 *                                                                           *
 * ========================================================================= *
 *                                                                           *
 * This software  consists of voluntary  contributions made  by many indivi- *
 * duals on behalf of the  Apache Software Foundation.  For more information *
 * on the Apache Software Foundation, please see <http://www.apache.org/>.   *
 *                                                                           *
 * ========================================================================= */

// CVS $Id: wa_provider.h,v 1.1 2001/02/14 07:33:47 jesse Exp $
// Author: Pier Fumagalli <mailto:pier.fumagalli@eng.sun.com>

#ifndef _WA_PROVIDER_H_
#define _WA_PROVIDER_H_

/**
 * The wa_provider structure describes a connection provider.
 */
struct wa_provider {
    /**
     * The name of this provider.
     */
    const char *name;

    /**
     * Configure a connection with the parameter from the web server
     * configuration file.
     *
     * @param conn The connection to configure.
     * @param param The extra parameter from web server configuration.
     * @return An error message or NULL.
     */
    const char *(*configure) (wa_connection *conn, char *param);

    /**
     * Initialize a connection.
     *
     * @param conn The connection to initialize.
     */
    void (*init) (wa_connection *conn);

    /**
     * Destroys a connection.
     *
     * @param conn The connection to destroy.
     */
    void (*destroy) (wa_connection *conn);

    /**
     * Describe the configuration member found in a connection.
     *
     * @param conn The connection for wich a description must be produced.
     * @param buf The buffer where the description must be stored.
     * @param len The buffer length.
     * @return The number of bytes written to the buffer (terminator included).
     */
    int (*conninfo) (wa_connection *conn, char *buf, int len);

    /**
     * Describe the configuration member found in a web application.
     *
     * @param appl The application for wich a description must be produced.
     * @param buf The buffer where the description must be stored.
     * @param len The buffer length.
     * @return The number of bytes written to the buffer (terminator included).
     */
    int (*applinfo) (wa_application *appl, char *buf, int len);


    /**
     * Handle a connection from the web server.
     *
     * @param req The request data.
     */
    void (*handle) (wa_request *req);
};

/* The list of all compiled in providers */
extern wa_provider *wa_providers[];

/* Pointers to the different providers */
extern wa_provider wa_provider_info;
extern wa_provider wa_provider_warp;

/* Function prototype declaration */
// Retrieve a provider.
wa_provider *wa_provider_get(char *);

#endif // ifndef _WA_PROVIDER_H_

