;; -*- Mode: Lisp -*-

(in-package :burp)

(define-wm burp-category-report ((element t) (category bug-category))
  (session-instance 'burp-category-report :category category))

(defclass burp-category-report (burp-page html-element)
  ((category
    :initarg :category
    :documentation
    "The category being examined"))
  )

(defclass category-links (html-element)
  ((category
    :initarg :category))
  )

(defmethod shared-initialize ((report burp-category-report) slots &rest)
  (call-next-method)
  (instantiate-children
   report
   `(("category"        static-string
      :value ,(lambda () (slot-value (slot-value report 'category) 'category-name)))
     ("bugs"    bug-list :category  ,(slot-value report 'category))
     ("subcat-links"  category-links :category  ,(slot-value report 'category))
     ("categories"   hyperlink
      :reference ,(refer-wm burp-categories)
      :value "Go back to the Category Display.")

     )))

(defclass bug-list (html-element)
  ((category
    :initarg :category))
  )

(defmethod render-html ((list bug-list) stream)
  (with-slots (category)
    list
    (dolist (bug (category-bugs category))
      (let ((bug-item (session-instance 'bug-list-item :bug bug)))
        (with-tag (:stream stream :tag "P")
          (render-html bug-item stream))))))

(defclass bug-list-item (html-element)
  ((display-bug
    :initarg :bug
    :accessor display-bug))
  )

(defmethod shared-initialize ((element bug-list-item) slot &rest)
  "display a single bug, one of a list of them"
  (call-next-method)
  (with-slots (bug-title bug-description)
    (display-bug element)
    (let ((text-description
          (if (string= bug-title "")
              (concatenate 'string (subseq bug-description 0
                                           (min (length bug-description) 40)) "...")
              bug-title)))
      (instantiate-children
       element
       `(("title" hyperlink
          :reference ,(refer-wm burp-bug-detail (display-bug element))
          :value ,text-description))))))


#|


        (with-slots (bug-title bug-description)
        bug
        (let ((title (if (string= bug-title "")
                         (concatenate 'string (subseq bug-description 0 (min (length bug-description) 40)) "...")
                         bug-title)))
          (with-tag (:stream stream :tag "P")
            (with-tag (:stream stream :tag "B")
              (format stream "Bug #~d: ~a"
                      (slot-value bug 'bug-id)
                      title)))
          (with-tag (:stream stream :tag "P")
            (format stream "    ~a" bug-description))
          (with-tag (:stream stream :tag "P")
            (format stream "Created 1/1/99 by ~a" (user-name (bug-creator bug))))
          (with-tag (:stream stream :tag "P")
            (format stream "Modified 1/1/99 by Joe Schmoe")))))))

|#





