;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;; $Id: testapp3.lisp,v 1.3 2000/09/13 12:51:06 jesse Exp $

;; Copyright (C) 1999, 2000 onShore Inc.
;; See the file 'COPYING' in this directory for terms.

;; IMHO Example Application 3

;; This example simply prints out hello, but it uses the IMHO template
;; mechanism to do so.  In order for this to work you must have your
;; default directory set to the directory containing testapp2.html.
;; Or you can modify the defapplication form, adding a :template-root
;; argument with the directory containing the testapp2.html template
;;
;; Unlike testapp2, in this application we use the notion of child
;; elements to embed live data into the web page.

(in-package :imho)

(defvar *hits* 0)

(defclass testapp3-element (html-element) ())


;; This defines what children elements testapp3-element instances
;; have.  Child elements are initialized *ONCE*, when the element is
;; created.

(defbindings testapp3-element
  `((hits
     :type static-string)))


;; Each time this element is rendered, increment the hit counter.  We
;; still want the template to be found tho, so we make sure to
;; (call-next-method) so that the default renderer for HTML-ELEMENT
;; instances will be called, which is what parses and renders the
;; template.
;;
;; The WITH-ELEMENT-VALUES macro allows us to bind the VALUE
;; slot of a child element to a symbol.  In this case we bind the
;; VALUE of the "hits" child, a STATIC-STRING element to the symbol
;; HITS.  STATIC-STRING elements render their VALUE slot as a string,
;; so by setting that to the value of *HITS*, we get our counter.

(defmethod render-html ((element testapp3-element) stream)
  (with-element-values (hits) element
		       (setf hits (incf *hits*)))
  (call-next-method))

(defapplication testapp3
  :base-url "testapp3"
  ;;:template-root "/directory/containing/templates/"
  :initial-element testapp3-element)

(run-application 'testapp3)
