;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: log.lisp,v 1.19 2002/02/19 16:19:29 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)

(defvar *imho-log-path* #p"/var/log/imho/*.log")

(defvar *imho-log-file* "imho")

(defvar *imho-log-stream* nil)

(defun ensure-log ()
  "Try to make sure that an activity log file exists and is writable"
  (handler-case
      (#+cmu without-scheduling
               #-cmu without-preemption
       (or *imho-log-stream*
           (let ((logfile (merge-pathnames *imho-log-file*
                                           *imho-log-path*)))
             (ensure-directories-exist logfile)
             (setf *imho-log-stream*
                   (open logfile
                         :direction :output
                         :if-exists :append
                         :if-does-not-exist :create)))))
    (error (c)
      (cmsg "Could not ensure log: ~A" c)
      nil)))
      
(defun log-event (event)
  "Write an event to IMHO's event log"
  (handler-case
      (let ((log-stream (ensure-log))
            (remote-ip "unknown"))
        (if *active-request*
            (setf remote-ip (client-ip)))
        (format log-stream
                "~12s - user - [~a] ~a~%"
                remote-ip
                #-cmu "print-time"
                #+cmu (ext:format-universal-time nil (get-universal-time))
                event)
        (force-output log-stream))
    (error (c)
      (cmsg "IMHO: unable to write log: ~s" c))))

(defun log-error (html-text)
  "spool out some error text to a log"
  (handler-case
      (with-open-file (stream "/var/log/imho/errors.html" :direction :output :if-exists :append :if-does-not-exist :create)
        (write-string html-text stream))
    (error ()
      (cmsg "Could not open error log"))))
  
(defun debugging (feature)
  "returns non-nil if FEATURE is being debugged"
  (member feature *debug-flags*))

(defmacro dformat (feature &rest format-args)
  `(when (debugging ,feature)
    (cmsg ,@format-args)))

(defun imho-debug (feature &key (enable t))
  "Control the state of the debug flag for the IMHO package.  The
:ENABLE keyarg when nil disables the specified feature.  When T, it
enables it.  It defaults to T.

Presently supported flags are:
:scripts          -- Prints out set of scripted components for each request
:warp             -- Prints out WARP protocol information
:warp-outfile     -- Writes WARP responses to an output file in /tmp
:profile          -- Profiling information for each request is printed
"
  (cond ((eql feature :monitor)
         (load "systems:imho;experimental;production-debug")
         (load "systems:imho;experimental;cmucl-error-patch")
         (load "systems:imho;experimental;application")))
  (if enable
      (pushnew feature *debug-flags*)
      (setf *debug-flags* (delete feature *debug-flags*))))







