;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: variables.lisp,v 1.20 2002/04/01 17:32:15 craig Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.
;;;
;;; Global and dynamic variables used by IMHO

(in-package :imho)

;; ------------------------------------------------------------
;; HTML

(defvar *default-dtd*
  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">"
  "Rightly or wrongly, the DTD asserted for all of the HTML that we
generate.")

;; HTTP

(defvar *default-headers* nil)

;; ------------------------------------------------------------
;; Logging and debugging


(defvar *production* t
  "When non-nil, establish a request-scope error handler to prevent
ever falling into the clutches of the debugger.  Can be overridden by
*debug-on-errors*.")

(defvar *postprocess-html* nil
  "Run ngsmls against generated HTML, with validation errors to console.")

(defvar *warn-deprecated* t
  "When non-nil, warn about use of deprecated interfaces")

(defvar *debug-on-errors* nil
  "When non-nil, dump into the debugger when an error occurs, rather
than returning the text of the error as HTML.")

(defvar *debug-lisp-server* t
  "When non-nil, print information on low-level requests to stdout.")

(defparameter *debug-flags* nil
  "keywords controlling what debug info to print")
  
(defvar *log-requests* nil
  "When non-nil, write logging information for requests (incomplete)")

(defvar *retentive* nil
  "When non-nil, generate errors in odd but non-critical situations.")

(defvar *refresh-parts* nil
  "When non-nil, recreate pages parts every txn (for use in page
development).")

;; ------------------------------------------------------------
;; Server

(defvar *lisp-server-port* 8007
  "JServ's 'mount' port")
(declaim (type fixnum *lisp-server-port*))

(defvar *imho-serving* nil
  "t when there is at least one active application.")

(defvar *lisp-server* nil
  "the lisp server process")

(defvar *lisp-listener* nil
  "the socket on which imho listens for jserv requests")

(defvar *timeout-monitor* nil
  "a process that reaps expired sessions")

(defvar *imho-active-apps* (make-hash-table :test 'equal)
  "running applications")

(defvar *accept-retry-limit* 10
  "Number times to retry accept-tcp-connection before throwing the
socket away in disgust.")

(defvar *imho-connectors*
  '((:mod-lisp . mod-lisp-server)
    (:warp . warp-server))
  "Available Apache<->Lisp connectors, and their corresponding server-
functions")

;; ------------------------------------------------------------
;; session control

(defvar *session-timeout-monitor-seconds* 15 
  "session-timeout-monitor sleeps this many seconds between runs")

(defvar *session-timeout-lock* (make-lock #-cmu :name "session-timeout-lock")
  "Lock for protecting the freeing of sessions from the accessing of sessions")

;; ------------------------------------------------------------
;; request dynamic variables

(defvar *active-application* nil
  "The currently active application is bound to this variable during
application-programmer visible potions of a request cycle.")

(defvar *active-session* nil
  "The currently active session is bound to this variable during
application-programmer visible potions of a request cycle.")

(defvar *active-request* nil
  "The currently active request is bound to this variable during
application-programmer visible potions of a request cycle.")

(defvar *active-url* nil
  "The currently active base URL is bound to this variable during
application-programmer visible potions of a request cycle.")

(defvar *active-components* nil
  "Any component classes that are getting returned on the current page
are listed here.")

(defvar *response-stream* nil
  "The response stream itself, for responses with unconventional mime
types")

