;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: filesystem.lisp,v 1.4 2002/03/29 04:23:43 craig Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.

(in-package :odcl)

#+cmu
(defun ensure-directory (path)
  (let ((path (split path #\/))
        (pathstring ""))
    (do ((path path (cdr path)))
        ((null path))
      (setq pathstring (concatenate 'string pathstring "/" (car path)))
      (unless (probe-file pathstring)
        (format t "Creating: ~s~%" pathstring)
        (unix:unix-mkdir pathstring #o755)
	(unix:unix-mkdir pathstring #o755)))))


#+cmu
(defun expand-directory (head)
  (let ((files nil)
        (subdirs nil)
        (dir (unix:open-dir head)))
    (when dir
      (unwind-protect
           (loop
            (let ((name (unix:read-dir dir)))
              (cond ((null name)
                     (return))
                    ((string= name "."))
                    ((string= name ".."))
                    (t
                     (let ((subdir (concatenate 'string head name)))
                       (case (unix:unix-file-kind subdir t)
                         (:directory
                          (push (concatenate 'string subdir "/") subdirs))
                         (:file
                          (push subdir files))))))))
        (unix:close-dir dir)))
    (values files subdirs)))

(defun files-under (directory)
  (when (not (null directory))
    (multiple-value-bind (subfiles subdirs)
	(expand-directory directory)
      (append
       subfiles
       (apply #'append (mapcar #'files-under subdirs))))))

(defun temp-file (&optional (prefix "lisp") (suffix "tmp"))
  (loop
   (let ((file (format nil "/tmp/~a.~a.~a" (random-string :length 8) prefix suffix)))
     (unless (probe-file file)
       (return-from temp-file file)))))
