;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: interactive.lisp,v 1.1 2001/11/14 16:27:20 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.

(in-package :odcl)

(defun read-int-with-default (default)
  (block read-int
    (tagbody
     read
     (let (port)
       (format t #i";; Enter an integer [default ~d]: " default)
       (setq port (read-line *standard-input*))
       (if (= (length port) 0)
	   (return-from read-int default))
       (if (every (lambda (c) (position c "0123456789")) port)
	   (setq port (parse-integer port))
           (progn
             (format t #i";; That wasn't obviously an integer, try again.~%")
             (go read)))
       (return-from read-int port)))))

(defun read-string-with-default (default)
  (block read-string
    (tagbody
     read
     (let (port)
       (format t #i";; Enter a string [default ~d]: " default)
       (setq port (read-line *standard-input*))
       (if (= (length port) 0)
	   (return-from read-string default))
       (return-from read-string port)))))
