;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: alist.lisp,v 1.17 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 2001 - 2003 onShore Development, Inc.

(in-package :odcl)

(defun alist-eltp (elt)
  (and (consp elt)
       (atom (car elt))
       (atom (cdr elt))))

(defun alistp (list)
  (when (listp list)
    (dolist (elt list)
      (unless (alist-eltp elt)
        (return-from alistp nil)))
    t))

(defmacro update-alist (item value alist &key (test '#'eql) (key '#'identity))
  "If alist already has a value for Key, it is updated to be Value.
Otherwise the passed alist is updated with key-value added as a new
pair."
  (let ((entry (gensym)))
    `(let ((,entry (assoc ,item ,alist :test ,test :key ,key)))
      (if ,entry
          (progn (setf (cdr ,entry) ,value)
                 ,alist)
          (setf ,alist (acons ,item ,value ,alist))))))

(defun get-alist (item alist &key (test #'eql))
  (cdr (assoc item alist :test test)))

(defun (setf get-alist) (value item alist &key (test #'eql))
  (update-alist item value alist :test test)
  value)

(defun flatten-alist (alist)
  (apply #'append (mapcar (lambda (x)
                            (list (car x) (cdr x))) alist)))

(defun alist->plist (alist &aux plist)
  (dolist (pair alist)
    (destructuring-bind (key . val)
        pair
      (push key plist)
      (push val plist)))
  (nreverse plist))

(defun plist->alist (plist)
  (and plist (cons (cons (car plist) (cadr plist)) (plist->alist (cddr plist)))))

(defun get-plist (item plist &key (test 'eql) (empty nil))
  (if-bind (key (member item plist :test test))
           (cadr key)
           empty))
