(in-package :odcl)

(defregression (:avl 1)
  "Make an AVL tree, add 100 items, remove 100 items."
  (let ((tree (make-instance 'odcl:avl-tree
                               :test '<)))
      (dotimes (x 1 100)
        (c-add tree x))

      (dotimes (x 1 100)
        (c-remove tree x))

      (assert (null (tree->list tree)))))

(defregression (:avl 2)
  "Check removal -- triggered bug in balance bookkeeping."
  (let ((tree (make-instance 'odcl:avl-tree
                             :test '<)))
    (dolist (x '(5 3 2 1 4))
      (c-add tree x))
      
    (dolist (x '(3 5 2 4 1))
      (c-remove tree x))

    (assert (null (tree->list tree)))))

(defregression (:avl 3)
  "Check insertion -- triggered bug in balance bookkeeping."
  (let ((tree (make-instance 'odcl:avl-tree
                             :test '<)))
    (dolist (x '(4 1 22 15 10))
      (c-add tree x))))

(defregression (:avl 4)
  "Test random adds and removes."
  (let ((tree (make-instance 'odcl:avl-tree
                             :test '<))
        (seen nil))
    (dotimes (x 1000)
      (let ((y (random 51234234)))
        (unless (member y seen)
          (push y seen)
          (c-add tree y)
          (if (evenp (random 23123))
              (let ((duck (nth (random (length seen)) seen)))
                (setq seen (remove duck seen))
                (c-remove tree duck)))
          (assert (= (length seen) (length (tree->list tree)))))))))

(defregression (:avl 5)
  "Incomplete test."
  (let ((tree (make-instance 'odcl::avl-tree
                             :test '<)))
    (c-add tree 1)
    ;; (describe (tree-root tree))
    (c-add tree -1)))

(defregression (:avl 6)
  "Add/remove."
  (let ((tree (make-instance 'odcl::avl-tree
                             :test '<)))
    (c-add tree 1)
    (c-add tree 2)
    (c-add tree 3)
    (c-add tree 4)
    (c-add tree 5)
    (c-remove tree 5)
    (c-add tree 5)))
