(in-package :odcl)

(defregression (:lru-cache 1)
  "Cache expiry."
  (let ((cache (make-instance 'lru-cache :size 10 :test #'=)))
    (dotimes (x 11)
      (cache-put cache x (random-string)))
    (when (cache-get cache 0)
      (error "Cache ought to have trashed 0 by now."))))

(defregression (:lru-cache 2)
  "Cache expiry - 2."
  (let ((cache (make-instance 'lru-cache :size 10 :test #'=)))
    (dotimes (x 10)
      (cache-put cache x (random-string)))
    (unless (cache-get cache 0)
      (error "Cache ought to still have 0 now."))))

(defregression (:lru-cache 3)
  "Expiry with marking."
  (let ((cache (make-instance 'lru-cache :size 10 :test #'=)))
    (dotimes (x 10)
      (cache-put cache x (random-string)))
    (cache-mark cache 0 t)
    (dotimes (x 10)
      (cache-put cache (+ 10 x) (random-string)))
    (unless (cache-get cache 0)
      (error "Cache ought to still have 0 now."))))

(defregression (:lru-cache 4)
  "Try to kill it w/ one too many marked entries."
  (let ((cache (make-instance 'lru-cache :size 10 :test #'=)))
    (dotimes (x 10)
      (cache-put cache x (random-string))
      (cache-mark cache x :sunshine))
    (cache-put cache 11 (random-string))))

(defregression (:lru-cache 4.1)
  "Try to kill it w/ one too many marked entries."
  (let ((cache (make-instance 'lru-cache :size 10 :test #'=)))
    (dotimes (x 100)
      (cache-put cache x (random-string) :spazz))))

(defregression (:lru-cache 5)
  "Try to kill it w/ far too many marked entries."
  (let ((cache (make-instance 'lru-cache :size 10 :test #'=)))
    (dotimes (x 100)
      (cache-put cache x (random-string))
      (cache-mark cache x :sunshine))))

(defregression (:lru-cache 6)
  "Check firing of insert/delete hooks."
  (let* ((cache (make-instance 'lru-cache :size 10 :test #'=))
         (ext-count 0))
    (push (lambda (e) (declare (ignore e)) (incf ext-count)) (insert-hook cache))
    (push (lambda (e) (declare (ignore e)) (error "delete hook should not fire")) (delete-hook cache))
    (dotimes (x 100)
      (cache-put cache x (random-string))
      (cache-mark cache x :sunshine))
    (unless (= 100 ext-count)
      (error "insert hooks did not fire (~d != ~d)" ext-count 100))))

(defregression (:lru-cache 7)
  "Check firing of insert/delete hooks."
  (let* ((cache (make-instance 'lru-cache :size 10 :test #'=))
         (ext-count 0))
    (push (lambda (e) (declare (ignore e)) (incf ext-count)) (insert-hook cache))
    (push (lambda (e) (declare (ignore e)) (decf ext-count)) (delete-hook cache))
    (dotimes (x 100)
      (cache-put cache x (random-string)))
    (unless (= 10 ext-count)
      (error "insert hooks did not fire (~d != ~d)" ext-count 10))))
