/*
	$Id: popupmenu_generic.h,v 1.8 2001/09/08 19:12:52 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_popupmenu_generic
#define header_popupmenu_generic

#include "API/GUI/popupmenu.h"

class CL_PopupMenu_Generic
{
public:
	static CL_ComponentOptions create_options(
		const CL_Point &pos);

	CL_PopupMenu_Generic(CL_PopupMenu *self, const CL_ComponentOptions &options, CL_StyleManager *style);
	~CL_PopupMenu_Generic();

	CL_PopupMenu *popupmenu;

	CL_Signal_v0 sig_cancelled;

private:
	CL_Slot slot_lost_focus;
	CL_Slot slot_child_add;
	std::list <CL_Slot *> slots_child_click;

	void on_child_add(CL_Component *child);
	void on_child_click(const CL_Key &key, CL_Component *component);
	void on_lost_focus();
};  

#endif
