/*
	$Id: key.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Input"

#ifndef header_key
#define header_key

class CL_Key
//: Structure descripting a key event.
{
public:
	int id;
	// Key ID. CL_Keyboard::KEY_xxx if it is the keyboard buffer.

	int ascii;
	// Ascii value or -1 if not available.

	enum State
	{
		NoKey,
		Pressed,
		Released
	} state;
	// Key state. Was it pressed or released. NoKey is used when there were
	// no key available in the input buffer.
	
	float x;
	// x-coordinate position if a pointing device was the source. -1 if none.
	
	float y;
	// y-coordinate position if a pointing device was the source. -1 if none.

	CL_Key() {
		id    = 0;
		state = NoKey;
		ascii = -1;
		x     = -1;
		y     = -1;
	}

	CL_Key(int l_id, State l_state = NoKey, int l_ascii = -1, float l_x = -1, float l_y = -1) {
		id    = l_id;
		state = l_state;
		ascii = l_ascii;
		x     = l_x;
		y     = l_y;
	}
};

#endif
