/*
	$Id: surface_manager.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Surface management functionality


*/

//! component="SurfaceProviders"

#ifndef header_surface_manager
#define header_surface_manager
/*
class CL_SurfaceManager_Priority
{
public:
	virtual int get_priority()=0;
	virtual void reset_priority()=0;
	virtual CL_Surface *get_surface()=0;
};

class CL_SurfaceManager_Card
{
protected:
	list<CL_SurfaceManager_Priority*> priority_list;
	CL_DisplayCard *card;

	static int compare_surfaces(const void *s1, const void *s2);

public:
	CL_SurfaceManager_Card(CL_DisplayCard *_card);
	virtual ~CL_SurfaceManager_Card() { ; }

	// add surface to priority list
	virtual void add_surface(CL_SurfaceManager_Priority *surf_prio);

	// remove surface from list
	virtual void remove_surface(CL_SurfaceManager_Priority *surf_prio);

	// move surfaces with highest priorities into video memory
	virtual void optimize_video();
};

class CL_FilterSurface : public CL_Surface, public CL_SurfaceManager_Priority
{
protected:
	CL_Surface *subsurface;

public:
	CL_FilterSurface(CL_Surface *_subsurface) { subsurface = _subsurface; }
	virtual ~CL_FilterSurface() { ; }

	virtual void reload() { subsurface->reload(); }
	virtual CL_SurfaceProvider *get_provider() const { return subsurface->get_provider(); }

	// Display functions
	virtual void put_screen(int x, int y, int spr_no=0, CL_DisplayCard *card=NULL)
	{ subsurface->put_screen(x, y, spr_no, card); }

	virtual void put_screen(int x, int y, float scale_x, float scale_y, int spr_no=0, CL_DisplayCard *card=NULL)
	{ subsurface->put_screen(x, y, scale_x, scale_y, spr_no, card); }

	virtual void put_screen(int x, int y, int size_x, int size_y, int spr_no=0, CL_DisplayCard *card=NULL)
	{ subsurface->put_screen(x, y, size_x, size_y, spr_no, card); }

	// is_video() returns true if in videomemory
	// on the specified card (null = current dispcard)
	virtual bool is_video(CL_DisplayCard *card = NULL) const
	{ return subsurface->is_video(card); }

	virtual bool is_loaded(CL_DisplayCard *card= NULL) const
	{ return subsurface->is_loaded(card); }

	// returns true if successfully loaded into videomemory, or already there
	virtual bool convert_video(CL_DisplayCard *card = NULL)
	{ return subsurface->convert_video(card); }

	// never fails! (or serious heap usage!)
	virtual bool convert_system(CL_DisplayCard *card = NULL)
	{ return subsurface->convert_system(card); }

	// completely flushes surface (removes from video/system-memory)
	virtual void flush(CL_DisplayCard *card = NULL)
	{ subsurface->flush(card); }

	virtual CL_Surface *get_surface() { return this; }

	virtual int get_width() const { return subsurface->get_width(); }
	virtual int get_height() const { return subsurface->get_height(); }
	virtual int get_no_sprs() const { return subsurface->get_no_sprs(); }
};

class CL_PeakSurface : public CL_FilterSurface
{
public:
	int blt_count;
	int default_prio;

	CL_PeakSurface(CL_Surface *surf, int _default_prio) : CL_FilterSurface(surf)
	{ blt_count = 0; default_prio = _default_prio; }

	virtual void put_screen(int x, int y, int spr_no=0, CL_DisplayCard *card=NULL)
	{
		blt_count++;
		CL_FilterSurface::put_screen(x, y, spr_no, card);
	}

	virtual void put_screen(int x, int y, float scale_x, float scale_y, int spr_no=0, CL_DisplayCard *card=NULL)
	{
		blt_count++;
		CL_FilterSurface::put_screen(x, y, scale_x, scale_y, spr_no, card);
	}

	virtual void put_screen(int x, int y, int size_x, int size_y, int spr_no=0, CL_DisplayCard *card=NULL)
	{
		blt_count++;
		CL_FilterSurface::put_screen(x, y, size_x, size_y, spr_no, card);
	}

	virtual void reset_priority()
	{
		blt_count = 0;
	}
	virtual int get_priority()
	{
		return blt_count*get_provider()->get_width()*get_provider()->get_height() + default_prio;
	}
};

class CL_PeakPriority : public CL_SurfacePriority
{
protected:
	CL_SurfaceManager_Card *manager;

public:
	CL_PeakPriority(CL_SurfaceManager_Card *_manager)
	{
		manager = _manager;
	}

	virtual ~CL_PeakPriority() { ; }

	virtual CL_Surface *manage_surface(CL_Surface *surf)
	{
		CL_PeakSurface *peaksurf = new CL_PeakSurface(surf, 0); // monitor the blits
		manager->add_surface(peaksurf);
		return peaksurf;
	}
};
*/
#endif
