/*
	$Id: outputsource_memory_generic.h,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef header_outputsource_memory_generic
#define header_outputsource_memory_generic

#include "API/Core/IOData/outputsource.h"

class CL_OutputSource_MemoryGeneric : public CL_OutputSource
//: Outputsource writing to memory_generic.
{
public:
	CL_OutputSource_MemoryGeneric(unsigned int blocksize = 16*1024);
	virtual ~CL_OutputSource_MemoryGeneric();
	
	void *get_data() const;
	//: Get the pointer to the internal data array in the memory_generic source.
	//: Used to extract the data after usage.
	//!retval: Pointer to the data written.

	virtual void set_system_mode();
	//: Changes output data endianess to the local systems mode.

	virtual void set_big_endian_mode();
	//: Changes output data endianess to big endian mode.

	virtual void set_little_endian_mode();
	//: Changes output data endianess to little endian mode. This is the 
	//: default setting.

	virtual void write_int32(int data);
	//: Writes a signed 32 bit integer to output source.

	virtual void write_uint32(unsigned int data);
	//: Writes a unsigned 32 bit integer to output source.

	virtual void write_short16(short data);
	//: Writes a signed 16 bit integer (short) to output source.

	virtual void write_ushort16(unsigned short data);
	//: Writes a unsigned 16 bit integer (short) to output source.

	virtual void write_char8(char data);
	//: Writes a signed 8 bit integer (char) to output source.

	virtual void write_uchar8(unsigned char data);
	//: Writes a unsigned 8 bit integer (char) to output source.

	virtual void write_float32(float data);
	//: Writes a ieee format floating point to output source.

	virtual void write_bool(bool data);
	//: Writes a bool to output source.

	virtual int write(const void *data, int size);
	//: Writes larger amounts of data (no endian and 64 bit conversion):
	//: <br>
	//!param: data - Points to the array written.
	//!param: size - Number of bytes to write.
	//!retval: Num bytes actually written.
	
	virtual void open();
	//: Opens the output source. By default, it is open.
	
	virtual void close();
	//: Closes the output source.

	virtual CL_OutputSource *clone();
	//: Make a copy of the current OutputSource, standing at the same position.
	//!retval: The copy of the output source.

	virtual int tell();
	//: Returns current position in output source.
	//!retval: Current position in source.

	virtual int size();
	//: Returns the size of the output source
	//!retval: Current size of output source.

	virtual void write_string(const char *string);
	//: Writes a string to the output source.

private:
	unsigned int m_blocksize;
	unsigned char *m_data;
	unsigned int m_size, m_pos;
};

#endif
