/*
	$Id: outputsource_memory.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/
#include "Core/precomp.h"
#include <API/Core/IOData/outputsource_memory.h>
#include <API/Core/System/cl_assert.h>

CL_OutputSource_Memory::CL_OutputSource_Memory()
{
	m_pos = 0;
}

CL_OutputSource_Memory::~CL_OutputSource_Memory()
{
}

std::string CL_OutputSource_Memory::get_data() const
{
	return m_data;
}

void CL_OutputSource_Memory::set_system_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_OutputSource_Memory::set_big_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_OutputSource_Memory::set_little_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_OutputSource_Memory::write_int32(int data)
{
	write(&data, sizeof(int));
}

void CL_OutputSource_Memory::write_uint32(unsigned int data)
{
	write(&data, sizeof(unsigned int));
}

void CL_OutputSource_Memory::write_short16(short data)
{
	write(&data, sizeof(short));
}

void CL_OutputSource_Memory::write_ushort16(unsigned short data)
{
	write(&data, sizeof(unsigned short));
}

void CL_OutputSource_Memory::write_char8(char data)
{
	write(&data, sizeof(char));
}

void CL_OutputSource_Memory::write_uchar8(unsigned char data)
{
	write(&data, sizeof(unsigned char));
}

void CL_OutputSource_Memory::write_float32(float data)
{
	write(&data, sizeof(float));
}

void CL_OutputSource_Memory::write_bool(bool data)
{
	write(&data, sizeof(bool));
}

int CL_OutputSource_Memory::write(const void *data, int size)
{
	m_data.append((const char *) data, size);
	m_pos += size;
	
	return size;
}

void CL_OutputSource_Memory::open()
{
}

void CL_OutputSource_Memory::close()
{
}

CL_OutputSource *CL_OutputSource_Memory::clone()
{
	cl_assert(false); // not implemented yet.
	return NULL;
}

int CL_OutputSource_Memory::tell()
{
	return m_pos;
}

int CL_OutputSource_Memory::size()
{
	return m_pos;
}

void CL_OutputSource_Memory::write_string(const char *string)
{
	int len = strlen(string)+1;
	write_int32(len);
	write((char*) string, len);
}
