/*
	$Id: cl_gobject.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <assert.h>
#include "../API/GUI/cl_gobject.h"

// Initialize class variables

//std::list<CL_GSlot> *CL_GObject::slots = new std::list<CL_GSlot>;
//std::list<CL_GConnection*> *CL_GObject::connections = new std::list<CL_GConnection*>;
CL_GObject* CL_GObject::last = NULL;

/* CL_GObject (constructor)
 *
 * Constructs a CL_GObject object
 */

CL_GObject::CL_GObject()
{
//std::list<CL_GMember> *signals = new std::list<CL_GMember>;
}

/* ~CL_GObject (destructor)
 *
 * Destroys a CL_GObject object
 */
CL_GObject::~CL_GObject()
{
	// remove any connections this object might have created
	std::list<CL_GConnection*>::iterator it = connections->begin();		
	while (it != connections->end())
	{		
		if (
			(*it)->get_sender() == this ||
			(*it)->get_reciever() == this)
		{
			CL_GConnection *conn = *it;
			connections->erase(it++);
			delete conn;			
		}		
		else it++;
	}
}

/* registerSignal
 *
 * Registers a signal so that it can later be used
 * to connect and emit. 
 */
void CL_GObject::register_signal(CL_GMember mem)
{
	std::list<CL_GMember>::iterator it = find(
		signals->begin(),
		signals->end(),
		mem);

	if (*it != mem) signals->push_back(mem);
}

/* deregisterSignal
 *
 * Registers a signal so that it can later be used
 * to connect and emit. 
 */
void CL_GObject::deregister_signal(CL_GMember mem)
{
	std::list<CL_GMember>::iterator it = find(
		signals->begin(),
		signals->end(),
		mem);

	if (*it == mem) signals->erase(it);
}

/* registerSlot
 *
 * Registers a member function so that the system knows which
 * functions are slots. 
 */
void CL_GObject::register_slot(CL_GSlot mem)
{
	assert(slots != NULL);

	std::list<CL_GSlot>::iterator it = find(
		slots->begin(),
		slots->end(),
		mem);

	if (*it != mem) slots->push_back(mem);
}

/* deregisterSlot
 *
 * Registers a member function so that the system knows which
 * functions are slots. 
 */
void CL_GObject::deregister_slot(CL_GSlot mem)
{
	std::list<CL_GSlot>::iterator it = find(
		slots->begin(),
		slots->end(),
		mem);

	if (*it == mem) slots->erase(it);
}

/* activateSignal
 *
 * Calls all slots that are connected to the given signal
 */

void CL_GObject::activate_signal(
	int nargs,
	CL_GObject *sender,
	CL_GMember mem,
	...)
{
	va_list ap;

	// Set the last sender pointer
	last = sender;
	va_start(ap, mem);
	if ( !connections->empty() )
	{
		for(
			std::list<CL_GConnection*>::iterator it = connections->begin();
			it != connections->end();
			it++)
		{		
			if (
				((*it)->get_sender() == sender) &&
				((*it)->get_signal() == mem))
			{
				CL_GObject *rec = (*it)->get_reciever();
				CL_GSlot slot = (*it)->get_slot();
				(rec->*slot)(nargs, ap);
			}
		}
	}
	va_end(ap);
}

/* connect
 *
 * Makes a connection between a specific object signal to a specific
 * object slot.
 */

void CL_GObject::connect(
	CL_GObject *sender,
	CL_GMember signal,
	CL_GObject *reciever,
	CL_GSlot slot)
{
	for(
		std::list<CL_GConnection*>::iterator it = connections->begin();
		it != connections->end();
		it++)
	{
		if (
			(*it)->get_sender() == sender &&
			(*it)->get_signal() == signal &&
			(*it)->get_reciever() == reciever &&
			(*it)->get_slot() == slot)
			return;
	}

	CL_GConnection *conn = new CL_GConnection(sender, signal, reciever, slot);
	//GCHECK(conn);

	connections->push_back(conn);
}

/* disconnect
 *
 * Removes a specific connection
 */
void CL_GObject::disconnect(
	CL_GObject* sender,
	CL_GMember signal,
	CL_GObject* reciever,
	CL_GSlot slot)
{
	for(
		std::list<CL_GConnection*>::iterator it = connections->begin();
		it != connections->end();
		it++)
	{
		if (
			(*it)->get_sender() == sender &&
			(*it)->get_signal() == signal &&
			(*it)->get_reciever() == reciever &&
			(*it)->get_slot() == slot)
		{
			delete *it;
			connections->erase(it);
			break;
		}		
	}
}


/* lastSender
 *
 * Returns a pointer to the last object that sent a signal.
 * Inside a slot this is guaranteed to give a pointer to the
 * object which emitted the signal.
 */

CL_GObject *CL_GObject::get_last_sender()
{
	return last;
}

/* debugSignals
 *
 * Writes some debugging information on the log file about the registered
 * signals and slots.
 */

void CL_GObject::debug_signals()
{
	char buffer[512];

	sprintf(
		buffer,
		"Signals registered: %d\tSlots registered: %d\t"
		"Connections registered: %d", 
		signals->size(),
		slots->size(),
		connections->size());

	cout << buffer << endl;
}
