########################################################################
#
# Function to specify non-option arguments on the command line
#
# (C) 1999-2001 Harald Kirsch (kirschh@lionbioscience.com)
#
# $Revision: 1.3 $, $Date: 2001/01/21 15:06:13 $
########################################################################

## source version and package require
source [file join [file dir [info script]] version.tcl]

## make sure, declOpt.tcl can be found
set auto_index(::clig::declOpt) \
    [list source [file join [file dir [info script]] declOpt.tcl]]

namespace eval ::clig {
  namespace export Rest

  variable RestSpec

  ## Rest has fixed params
  set RestSpec(fixed) {
    var {name of variable to receive non-option arguments}
    usage {description of non-option arguments}
  }

  set RestSpec(opts) {-c}

  ## Rest has option -c
  set RestSpec(-c,type) Int
  set RestSpec(-c,var) count
  set RestSpec(-c,count) {2 2}
  set RestSpec(-c,range) {0 oo}
  set RestSpec(-c,default) {0 oo}
  set RestSpec(-c,usage) \
      {declar minimum and maximum allowed number of non-option arguments} 

  ## usage string
  set RestSpec(usage) {declare the number of non-option arguments}
}
########################################################################
proc ::clig::Rest {var usage args} {
  if {[catch {declOpt Rest -- $var $usage $args} err]} {
    return -code error $err
  }
}
########################################################################
