(defvar x1)
(defvar x2)
(defvar x3)
(defvar y)
(defvar z)

(defun elementary-benchmark (N repeat)
  (setq x1 (floor (+ (isqrt (* 5 (expt 10 (* 4 N)))) (expt 10 (* 2 N))) 2))
  (setq x2 (isqrt (* 3 (expt 10 (* 2 N)))))
  (setq x3 (+ (expt 10 N) 1))
  (format t "~&~%N = ~D, Multiplication x1*x2, divide times by ~D~%" N repeat)
  (dotimes (count 3)
    (time
      (dotimes (_ repeat)
        (setq y (* x1 x2)))))
  (format t "~&~%N = ~D, Division (with remainder) x1 / x2, divide times by ~D~%" N repeat)
  (dotimes (count 3)
    (time
      (dotimes (_ repeat)
        (multiple-value-setq (y z) (floor x1 x2)))))
  (format t "~&~%N = ~D, integer_sqrt(x3), divide times by ~D~%" N repeat)
  (dotimes (count 3)
    (time
      (dotimes (_ repeat)
        (setq y (isqrt x3)))))
  (format t "~&~%N = ~D, gcd(x1,x2), divide times by ~D~%" N repeat)
  (dotimes (count 3)
    (time
      (dotimes (_ repeat)
        (setq y (gcd x1 x2)))))
)

(defun pari-benchmark (N repeat)
  (format t "~&~%N = ~D, pari-benchmark, divide times by ~D~%" N repeat)
  (dotimes (count 3)
    (time
      (dotimes (_ repeat)
        (let ((u 1) (v 1) (p 1) (q 1))
          (do ((k 1 (1+ k)))
              ((> k N) (setq y p z q))
            (let ((w (+ u v)))
              (shiftf u v w)
              (setq p (* p w))
              (setq q (lcm q w)))))))))

(defun integer-benchmark ()
  (elementary-benchmark 100 10000)
  (elementary-benchmark 1000 1000)
  (elementary-benchmark 10000 10)
  (elementary-benchmark 100000 1)
  (pari-benchmark 100 100)
  (pari-benchmark 200 10)
  (pari-benchmark 1000 1)
)
