/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#ifndef _DIRECTORY_H_
#define _DIRECTORY_H_

#include "FileSystemComposite.h"
#include "Path.h"
#include <string>
#include <sys/types.h>
#include <dirent.h>

using namespace std;

class Directory : public FileSystemComposite
{
public:
  /* True if aPath is the name of a directory.
     False if the path does not exist, or it is not a directory
     */
  static bool Exists(string const &aPath);
  static void Create(string const &aPath);
  static void RemoveRecursive(Path const &aPath);
  static string CurrentDirectory();
  
  Directory (string const &aPath, mode_t const &protection = mode_t());
  ~Directory();

  void visit (FileSystemVisitor &);
  Path const &path() const { return _path; }

  /* make private? */
  mode_t mode;
  
private:
  static void CreateFrom (string const &basePath, string const &aPath);
  static void StripSlash (string &aString);
  /* Don't allow copying */
  Directory &operator= (Directory const &);
  Directory (Directory const &);

  void visitEntry (struct dirent *entry, FileSystemVisitor &theVisitor);

  DIR *theDir;
  Path _path;
};

#endif // _DIRECTORY_H_
