/* Conky, a system monitor, based on torsmo
 *
 * Any original torsmo code is licensed under the BSD license
 *
 * All code written since the fork of torsmo is licensed under the GPL
 *
 * Please see COPYING for details
 *
 * Copyright (c) 2008 Markus Meissner
 * Copyright (c) 2005-2008 Brenden Matthews, Philip Kovacs, et. al.
 *	(see AUTHORS)
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id: nvidia.c 1122 2008-06-03 20:46:15Z brenden1 $
 */

#include "nvidia.h"

int get_nvidia_value(QUERY_ID qid, Display *dpy, int highorlow){
	int tmp;
	if(!XNVCTRLQueryAttribute(dpy, 0, 0, qid, &tmp)){
		return 0;
	} else if (qid == NV_GPU_FREQ){
		if (highorlow == 1)
			return tmp >> 16;
		else
			return tmp & 0x0000FFFF;
	} else
		return tmp;
}

