/*
** Copyright 1998 - 2006 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"dbobj.h"
#include	"rfc822/rfc822.h"
#include	"numlib/numlib.h"

#include	<ctype.h>
#include	<time.h>
#include	<iostream>
#include	<fstream>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sysexits.h>
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

static const char rcsid[]="$Id: cmlm3.C,v 1.13 2006/05/28 15:29:51 mrsam Exp $";

CString cmdget(const char *name)
{
ifstream ifs(OPTIONS);
CString	buf;

	while ((buf << ifs) == 0)
	{
	const char *p=buf;
	const char *q=strchr(p, '=');

		if (!q)	continue;

		if (strncmp(name, p, q-p) == 0 && name[q-p] == 0)
		{
			buf= q+1;
			return (buf);
		}
	}
	buf="";
	return (buf);
}


/* I also want to encode /s as well, sometimes */

#define	VERPSPECIAL	"@:%!+-[]/"

static const char xdigit[]="0123456789ABCDEFabcdef";

CString toverp(CString addr)
{
CString	buf=addr;
int	i=buf.ReverseFind('@');

	if (i < 0)
	{
		buf="";
		return (buf);
	}
	buf[i]='=';

	for (i=0; i<buf.GetLength(); i++)
	{
		if (strchr(VERPSPECIAL, buf[i]) == 0)	continue;
		buf=buf.Left(i)+ '+' + xdigit[ (buf[i] >> 4) & 15] +
			xdigit[buf[i] & 15] + buf.Mid(i+1);
		i += 2;
	}
	return (buf);
}

CString fromverp(CString addr)
{
CString	buf=addr;
char	*p=buf.GetBuffer(-1);
char	*q=p;
char	*r;

	while (*p)
	{
		if (*p != '+' || p[1] == 0 || p[2] == 0)
		{
			*q++=*p++;
			continue;
		}

		++p;
	int a=0, b=0;

		r=strchr(xdigit, *p++);
		if (r)	a= r-xdigit;
		r=strchr(xdigit, *p++);
		if (r)	b= r-xdigit;

		if (a >= 16) a -= 6;
		if (b >= 16) b -= 6;

		*q++= (char)(a*16+b);
	}
	*q=0;
	buf.ReleaseBuffer(-1);

int	i=buf.ReverseFind('=');

	if (i < 0)
		buf="";
	else
		buf[i]='@';
	return (buf);
}

CString get_verp_return(const char *pfix, const char *addr)
{
CString	n=cmdget("ADDRESS");
int	i=n.ReverseFind('@');
CString	buf="";

	if (i < 0)	return(buf);
	buf=n.Left(i) + '-';
	if (pfix && pfix[0])
		buf += pfix;

	if (addr)
	{
		buf += '-';
		buf += toverp(addr);
	}

	buf += n.Mid(i);
	return (buf);
}

CString mkfilename()
{
CString	filename, buffer2;
char	*p=filename.GetBuffer(256);

	p[255]=0;
	if (gethostname(p, 255))
		strcpy(p, "courier-mlm");

	// Drop any 8-bit characters from the hostname, to avoid creating
	// illegal mail headers.

	while (*p)
	{
		*p &= 127;
		++p;
	}

	filename.ReleaseBuffer(-1);

	// ostringstream replacement

	time_t	t;
	char tbuf[NUMBUFSIZE];
	char pbuf[NUMBUFSIZE];

	time(&t);

	libmail_str_time_t(t, tbuf);
	libmail_str_pid_t(getpid(), pbuf);

	buffer2=tbuf;
	buffer2 += ".";
	buffer2 += pbuf;
	buffer2 += ".";
	buffer2 += filename;

	return (buffer2);
}

CString mktmpfilename()
{
CString	f;
unsigned	n=0;
struct	stat	stat_buf;

	do
	{
		if (n)	sleep(n);
		n=3;
		f=mkfilename();
	} while ( stat( TMP "/" + f, &stat_buf) == 0);
	return (f);
}


/*
** Check whether an address can post to this list (whether it's listed as
** either a subscriber, or an alias.
*/
static int is_subscriber_1(const char *, const char *);

int is_subscriber(const char *from)
{
int	rc;

	if (from == 0 || *from == 0)	return (EX_NOUSER);

	rc=is_subscriber_1(".", from);
	if (rc && rc != EX_NOUSER)
		return (rc);
	if (rc)
	{
	CString	digestdir=cmdget("DIGEST");

		if (digestdir.GetLength() > 0)
			rc=is_subscriber_1(digestdir, from);
	}
	return (rc);
}

static int is_subscriber_1(const char *dir, const char *from)
{
int	rc;

	rc=getinfodir(dir, from, isfound);

	if (rc == 0)	return (0);

	/* Not on subscription rolls, maybe an alias */

CString	shared_lock_name=dir;

	shared_lock_name += "/";
	shared_lock_name += SUBLOCKFILE;

SharedLock alias_lock(shared_lock_name);
DbObj	alias;

CString	alias_name=dir;

	alias_name += "/" ALIASES;

	if (alias.Open(alias_name, "R") == 0)
	{
	CString key;
	char	*p;

		key="1";
		key += from;
		p=key.GetBuffer(-1);

		addrlower(p);

	char	*v;
	size_t	vl;

		if ((v=alias.Fetch(key, key.GetLength(), vl, "")) != 0)
		{
			free(v);
			rc=0;
		}
	}
	return (rc);
}

int getinfo(const char *a, int (*func)(const char *, size_t))
{
	return (getinfodir(".", a, func));
}

int getinfodir(const char *dir, const char *a,
	int (*func)(const char *, size_t))
{
CString	addrbuf(a ? a:"");
char	*address;
char	*p;
struct	stat	stat_buf;

	if (a == 0 || (p=strchr(address=addrbuf.GetBuffer(-1), '@')) == 0
		|| strchr(p+1, '@') || strchr(p, '/'))
	{
		cerr << "Invalid address." << endl;
		return (EX_SOFTWARE);
	}

	addrlower(address);


CString	shared_lock_name=dir;

	shared_lock_name += "/";
	shared_lock_name += SUBLOCKFILE;

SharedLock subscription_lock(shared_lock_name);

CString	buf;

	buf=dir;

	buf += "/" DOMAINS "/";
	buf += p+1;

DbObj	domain_file;

	if (stat(buf, &stat_buf) == 0 && domain_file.Open(buf, "W") == 0)
	{
	char	*val;
	size_t	l;

		if ((val=domain_file.Fetch(address, strlen(address), l, ""))
			!= 0)
		{
		int	rc= (*func)(val, l);

			free(val);
			domain_file.Close();
			return (rc);
		}

		domain_file.Close();
		return (EX_NOUSER);
	}

char	*r;
size_t	rlen;
size_t	i, j, k;

	buf=dir;
	buf += "/" MISC;
	if (domain_file.Open(buf, "W"))
	{
		return (EX_NOUSER);
	}

	if ((r=domain_file.Fetch(p+1, strlen(p+1), rlen, "")) == 0)
	{
		domain_file.Close();
		return (EX_NOUSER);
	}

	k=0;
	for (i=0; i<rlen; )
	{
		for (j=i; j < rlen && r[j]; j++)
			;
		if (j >= rlen)	break;
		++j;
		if (strcmp(r+i, address) == 0)
		{
		int	rc=EX_NOUSER;

			i=j;
			while (j < rlen && r[j])
				j++;
			if (j < rlen)
				rc= (*func)(r+i, j-i);

			domain_file.Close();
			return (rc);
		}

		while (j < rlen && r[j])
			j++;
		if (j >= rlen)	break;
		++j;
		i=j;
	}

	domain_file.Close();
	return (EX_NOUSER);
}

int isfound(const char *, size_t)
{
	return (0);
}

const char *myname()
{
static	CString	myname_buf;

	if (myname_buf.GetLength() == 0)
	{
		myname_buf="\"";
		myname_buf += cmdget("NAME");
		if (myname_buf.GetLength() <= 1)
			myname_buf += "Courier Mailing List Manager";
		myname_buf += "\"";
	}
	return (myname_buf);
}


// Run sendmail in the background

int sendmail(const char **argv, pid_t &p)
{
int	pipefd[2];

	while (pipe(pipefd) == -1)
	{
		perror("pipe");
		sleep(5);
	}

	while ((p=fork()) == -1)
	{
		perror("fork");
		sleep(5);
	}

	if (p == 0)
	{
	char	*fakeenv=0;

		dup2(pipefd[0], 0);
		close(pipefd[0]);
		close(pipefd[1]);

		execve(SENDMAIL, (char **)argv, &fakeenv);
		perror("exec");
		exit(1);
	}
	close(pipefd[0]);
	return (pipefd[1]);
}

int wait4sendmail(pid_t p)
{
int	waitstat;
pid_t	p2;

	while ((p2=wait(&waitstat)) != p)
		;
	if (WIFEXITED(waitstat))
		return (WEXITSTATUS(waitstat));
	return (EX_TEMPFAIL);
}

//
// Run sendmail with the -bcc flag, requesting only FAIL notices.
//

int sendmail_bcc(pid_t &p, const char *from)
{
const char	*argvec[7];

	argvec[0]="sendmail";
	argvec[1]="-bcc";
	argvec[2]="-f";
	argvec[3]=from;
	argvec[4]="-N";
	argvec[5]="fail";
	argvec[6]=0;
	return (sendmail(argvec, p));
}

////////////////////////////////////////////////////////////////////////////
//
// Read message, up to 16K bytes of it.
//

CString	readmsg()
{
char	msgbuf[16384];
size_t	i, j;

	for (i=0; i<sizeof(msgbuf); )
	{
		cin.read(msgbuf+i, sizeof(msgbuf)-i);

	int	n=cin.gcount();

		if (n <= 0)	break;
		i += n;
	}

	for (j=0; j<i; j++)
		if (msgbuf[j] == 0)	msgbuf[j]=' ';

CString	b;

	memcpy(b.GetBuffer(i), msgbuf, i);
	b.ReleaseBuffer(i);
	return (b);
}

//
// Extract a specific header.
//

CString header(const char *msg, const char *header)
{
CString	hdr;
int	c;
int	ismyheader;

	while (*msg)
	{
		if (*msg == '\n')	break;
		hdr="";
		while (*msg != '\n' && *msg != ':')
		{
			c= (unsigned char)*msg++;
			c=tolower(c);
			hdr += (char)c;
		}
		ismyheader= hdr == header;
		hdr="";
		if (*msg == ':')	++msg;
		while (*msg)
		{
			while (*msg && *msg != '\n')
			{
				if (ismyheader)
					hdr += (char)*msg;
				++msg;
			}
			if (ismyheader)
				hdr += '\n';
			if (!*msg)	break;
			++msg;
			if (*msg != ' ' && *msg != '\t')	break;
		}
		if (ismyheader)
		{
			// Replace newlines followed by whitespace with a
			// single space.

		char	*p=hdr.GetBuffer(-1), *q=p;

			while (*p)
			{
				if (*p != '\n')
				{
					*q++ = *p++;
					continue;
				}
				while (*p && isspace((int)(unsigned char)*p))
					++p;
				*q++=' ';
			}
			*q=0;
			hdr.ReleaseBuffer(-1);
			return (hdr);
		}
	}
	hdr="";
	return (hdr);
}

//
//  Addresses to subscribe/unsubscribe are derived in two ways:
//
//  * From the headers.
//
//  * Explicitly specified in the subscription address:
//                 To:  list-subscribe-luser=host@listdomain
//
//  If we find an explicit address, use that.  Otherwise, grep the headers.
//

CString returnaddr(CString msg, const char *explicit_address)
{
CString addr;
int	i, j, k;

	if (explicit_address && *explicit_address)
	{
		addr=fromverp(explicit_address);
	}
	else
	{
		// Preference:  Reply-To:, then From:, then envelope Sender.

		addr=header(msg, "reply-to");

		if (addr == "")	addr=header(msg, "from");
		if (addr == "")
		{
		const char *p=getenv("SENDER");

			if (!p)	return (addr);
			addr=p;
		}
		else
		{
//
//  Grabbed the header, must now parse an address out of it.
//
		struct rfc822t *t=rfc822t_alloc_new(addr, NULL, NULL);

			if (!t)
			{
				perror("malloc");
				return (1);
			}

		struct rfc822a *a=rfc822a_alloc(t);

			if (!a)
			{
				perror("malloc");
				return (1);
			}

			if (a->naddrs <= 0)
			{
				addr="";
				rfc822a_free(a);
				rfc822t_free(t);
				return (addr);
			}

		char	*s=rfc822_getaddr(a, 0);

			rfc822a_free(a);
			rfc822t_free(t);

			if (!s)
			{
				perror("malloc");
				return (1);
			}

			addr=s;
			free(s);
		}
	}

// Sanity check: all addresses must have an @

	k=0;
	j=addr.GetLength();
	for (i=0; i<j; i++)
	{
		if (addr[i] == '@')	++k;
	}

	if (k != 1)
		addr="";
	return (addr);
}
