/*
** Copyright 1998 - 2000 Double Precision, Inc.  See COPYING for
** distribution information.
*/


/*
** $Id: filter.c,v 1.9 2007/05/06 21:49:29 mrsam Exp $
*/
#include	"filter.h"
#include	"buf.h"
#include	"sqwebmail.h"
#include	<string.h>

/*static void filter_for_saving(const char *, size_t);*/
static void filter_for_display(struct filter_info *, const char *, size_t);

static void filter_noop(struct filter_info *info,
			const char *buf,
			size_t size)
{
	(*info->handler_func)(buf, size, info->func_arg);
}

void	filter_start(struct filter_info *info,
		     int mode, void (*handler)(const char *, size_t, void *),
		     void *arg)
{
	info->handler_func=handler;
	info->func_arg=arg;

	buf_init(&info->disp_buf);

	switch (mode)	{
	case FILTER_FOR_SAVING:
		info->filter_func=filter_noop;
		break;
	case FILTER_FOR_DISPLAY:
		info->filter_func= &filter_for_display;
		info->linesize=EXTLINESIZE;
		break;
	case FILTER_FOR_PREVIEW:
		info->filter_func= &filter_for_display;
		info->linesize=MYLINESIZE;
		break;
	}
}
	
void	filter(struct filter_info *info, const char *ptr, size_t cnt)
{
	(*info->filter_func)(info, ptr, cnt);
}

void	filter_end(struct filter_info *info)
{
	(*info->filter_func)(info, 0, 0);
	buf_free(&info->disp_buf);
}

static void wordwrap(struct filter_info *info, const char *buf, size_t cnt,
		     void (*func)(struct filter_info *, const char *, size_t))
{
size_t	i;

	if (cnt == 0 || *buf == '>')	/* Do not wordwrap quoted lines */
	{
		(*func)(info, buf, cnt);
		(*func)(info, "\n", 1);
		return;
	}
	for (i=0; i<cnt;)
	{
	size_t	j;
	size_t	spacepos, restartpos;

		spacepos=restartpos=cnt;
		for (j=i; ; j++)
		{
			if (j >= i+info->linesize && spacepos <= j)
				break;
			if (j >= cnt)
			{
				spacepos=restartpos=j;
				break;
			}
			if (buf[j] == ' ')
			{
				spacepos=j;
				restartpos=j+1;
			}
		}
		(*func)(info, buf+i, spacepos-i);
		(*func)(info, "\n", 1);
		i=restartpos;
	}
}

/***************************************************************************/

static void dodisplay(struct filter_info *info, const char *, size_t);

static void filter_for_display(struct filter_info *info,
			       const char *ptr, size_t cnt)
{
size_t	i;

	if (!ptr)
	{
		if (info->disp_buf.cnt)
			wordwrap(info, info->disp_buf.ptr,
				 info->disp_buf.cnt, dodisplay);
		info->disp_buf.cnt=0;
		return;
	}

	buf_memcat(&info->disp_buf, ptr, cnt);
	for (;;)
	{
		for (i=0; i<info->disp_buf.cnt; i++)
			if (info->disp_buf.ptr[i] == '\n')
				break;
		if (i >= info->disp_buf.cnt)	break;
		wordwrap(info, info->disp_buf.ptr, i, dodisplay);
		buf_trimleft(&info->disp_buf, i+1);
	}
}

static void dodisplay(struct filter_info *info, const char *buf, size_t cnt)
{
size_t	i,j;
const char *p=0;
char	charbuf[6];

	for (i=j=0; i<cnt; i++)
	{
		switch (buf[i])	{
		case '<':
			p="&lt;";	break;
		case '>':
			p="&gt;";	break;
		case '&':
			p="&amp;";	break;
		case '"':
			p="&quot;";	break;
		default:
			if (ISCTRL(buf[i]) && buf[i] != '\n')
			{
				sprintf(charbuf, "&#%d;",
					(int)(unsigned char)buf[i]);
				p=charbuf;
			}
			else
				continue;
		}
		if (i > j)
			(*info->handler_func)(buf+j, i-j, info->func_arg);
		(*info->handler_func)(p, strlen(p), info->func_arg);
		j=i+1;
	}
	if (i > j)
		(*info->handler_func)(buf+j, i-j, info->func_arg);
}
