/*****************************************************************
 *
 *   set_locale.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#include "cpanel.h"
#include "defaults.h"

/* Window Managers */
extern gboolean wmaker;
extern gboolean enlightenment;
extern gboolean afterstep;
extern gboolean blackbox;
extern gboolean icewm;
extern gboolean sawmill;
extern gboolean gnome_session;
extern gboolean kde;
extern gboolean kde2;

extern gboolean if_gb;
extern gchar locale[STR_BUFFER_SIZE];
extern gchar wm_command[STR_BUFFER_SIZE];
extern gboolean if_cv_wm;

extern gboolean is_xacv;

gboolean temp_cv_wm;
GtkWidget *locale_combo;
GtkWidget *combo;
GtkWidget *check_button;

void save_xsession(void);

void use_cv(GtkWidget *button, gpointer *data)
{
	if(!if_cv_wm)
		temp_cv_wm=1;
	else
		temp_cv_wm=0;
}

void ok_set_locale(GtkWidget *button, gpointer *data)
{
	strcpy(locale,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(locale_combo)->entry)));
	strcpy(wm_command,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)));
	if_cv_wm = temp_cv_wm;
	save_xsession();
}

void def_set_locale(GtkWidget *button, gpointer *data)
{
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(locale_combo)->entry),LOCALE);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_button),IF_CV_WM);
}

void help_set_locale(GtkWidget *button, gpointer *data)
{
	show_help("set_locale_opt",_("Help - Set Locale"), 600,300);
}

void set_locale_opt(GtkWidget *button, gpointer *data)
{
	/* entry[]: 0.locale */
	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *def_button;
	GtkWidget *help_button;
	GtkWidget *separator;
	GList *locales =NULL;
	GList *items =NULL;
	gchar def_wm[30] = "TYPE ME!";
	GtkWidget *label;
 
temp_cv_wm = if_cv_wm;
	win = make_opt_win(_("Options - Set Locale"),button);

	vbox = gtk_vbox_new(FALSE,0);

	hbox = gtk_hbox_new(FALSE,0);
	label = gtk_label_new(_("Locale: "));
	locales = g_list_append(locales,"zh_TW.Big5");
	locales = g_list_append(locales,"zh_CN.GB2312");
	locale_combo = gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(locale_combo),locales);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(locale_combo)->entry),locale);
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(locale_combo)->entry),TRUE);

	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,1);
	gtk_box_pack_start(GTK_BOX(hbox),locale_combo,FALSE,FALSE,1);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);
	
	label = gtk_label_new(_("Set Window Manager: "));
	if(wmaker) {
		items = g_list_append(items,"wmaker");
		strcpy(def_wm,"wmaker");
	}
	if(enlightenment) {
		items = g_list_append(items,"enlightenment");
		strcpy(def_wm,"enlightenment");
	}
	if(afterstep) {
		items = g_list_append(items,"afterstep");
		strcpy(def_wm,"afterstep");
	}
	if(blackbox) {
		items = g_list_append(items,"blackbox");
		strcpy(def_wm,"blackbox");
	}
	if(icewm) {
		items = g_list_append(items,"icewm");
		strcpy(def_wm,"icewm");
	}
	if(sawmill) {
		items = g_list_append(items,"sawmill");
		strcpy(def_wm,"sawmill");
	}
	if(gnome_session) {
		items = g_list_append(items,"gnome-session");
		strcpy(def_wm,"gnome-session");
	}
	if(kde) {
		items = g_list_append(items,"kde");
		strcpy(def_wm,"kde");
	}
	if(kde2) {
		items = g_list_append(items,"kde2");
		strcpy(def_wm,"kde2");
	}

	combo = gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(combo),items);
	if(strlen(wm_command))
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),wm_command);
	else
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),def_wm);
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),combo,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);

	check_button = make_check_opt(_("Use CV"),if_cv_wm);
	gtk_signal_connect(GTK_OBJECT(check_button),"toggled",
			GTK_SIGNAL_FUNC(use_cv),NULL);
	if(is_xacv)
	gtk_box_pack_start(GTK_BOX(vbox),check_button,FALSE,FALSE,1);

	/* --------------------------------------------------- */
        ok_button = gtk_button_new_with_label(_("OK"));
        gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
                        GTK_SIGNAL_FUNC(ok_set_locale),NULL);
	
        cancel_button = gtk_button_new_with_label(_("Cancel"));

        def_button = gtk_button_new_with_label(_("Use Defaults"));
        gtk_signal_connect(GTK_OBJECT(def_button),"clicked",
                        GTK_SIGNAL_FUNC(def_set_locale),NULL);

        help_button = gtk_button_new_with_label(_("Help"));
        gtk_signal_connect(GTK_OBJECT(help_button),"clicked",
                        GTK_SIGNAL_FUNC(help_set_locale),NULL);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);
	hbox = make_button(ok_button,cancel_button,def_button,help_button,win,button);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_widget_show_all(win);
}

void set_locale_help(GtkWidget *button, gpointer *data)
{
	show_help("set_locale_help",_("Help - Set Locale"),600,300);
}

void save_xsession(void)
{
	FILE *f;
	gchar *path;
	
	path = g_strconcat(getenv("HOME"),"/",SET_LOCALE_FILE_NAME,NULL);

	f = fopen(path, "w");
	if(!f)
	{
		printf("Error saving locale at: %s\n",path);
		printf("Does $HOME point to your home dir??\n");
		g_free(path);
		return;
	}

	fprintf(f,"LANG=%s\n",locale);
	fprintf(f,"LC_ALL=%s\n",locale);
	fprintf(f,"LC_CTYPE=%s\n",locale);
	fprintf(f,"KDE_LANG=%s\n",locale);
	fprintf(f,"export LANG LC_ALL LC_CTYPE KDE_LANG\n",locale);
	fprintf(f,"exec ");
	if(if_cv_wm)
		fprintf(f,"cv ");
	fprintf(f,"%s",wm_command);

	fclose(f);
	g_free(path);
}
