/*
  bytecode: example bytecode
  Copyright (C) 2004-2006  Andrea Arcangeli <andrea@cpushare.com>
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation;
  only version 2.1 of the License.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <signal.h>
#include <math.h>
#include <string.h>

//#define MALICIOUS

#include <seccomp-loader.h>

#if !defined(__i386__) && (!defined(__powerpc__) || defined(__powerpc64__))
#error "only x86 and ppc are supported, not enough resources to port to other archs yet"
#endif

volatile unsigned int count;
/* Declaring this as an unsigned long cause a segfault in the
   floating point emulation code on ppc, probably we miss the
   library initialization callback, clearly we need
   quite some work to be more generic. */
volatile unsigned int count2 = 1;
volatile unsigned int quit;

void sighandler(int signal)
{
	unsigned long count_network;

	if (signal != SIGQUIT)
		sys_exit(200);
#ifdef MALICIOUS
	sys_getpid();
#endif

	count_network = htonl(count);
	sys_write(1, (char *) &count_network, sizeof(count_network));

	quit = 1;
}

int fact(int n)
{
	if (n == 1)
		return 1;
	else
		return n * fact(n-1);
}

void bytecode(unsigned char * mem, int heap_size, int stack_size)
{
	double x = 0;
	if (count != 0)
		sys_exit(201);
	if (count2 != 1)
		sys_exit(202);
	for (;;) {
		memset(mem, 0, heap_size);
		fact(200000);
		if (!(count++ % 2)) {
			count2 += count + sin(count) + x;
			x = cos(count) + count;
		}
		if (quit)
			sys_exit(0);
	}
}
