"=====================================================================
" cream-devel.vim -- developer related functions and mappings
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2002-2004  Steve Hall
" 
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
" 
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
" 
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"
" Description:
" Cream developer functions
"

if !exists("g:cream_dev")
	finish
endif

"______________________________________________________________________
" minimize Vim

" * Remember: we map Ctrl+Shift+V to start Vim in the window manager
" * Note: <M-v> destroys the German  so we double it
imap <silent> <M-v>v     <C-o>:suspend<CR>
imap <silent> <M-V>V     <C-o>:suspend<CR>
imap <silent> <M-v><M-v> <C-o>:suspend<CR>
imap <silent> <M-V><M-V> <C-o>:suspend<CR>


"______________________________________________________________________
" test progress bar from 1-100%
function! BarTest()
	let i = 0
	while i < 101
		call ProgressBar(i, "    Loading files... ", "#", 0)
		sleep 10m
		let i = i + 1
	endwhile
endfunction

