/* cfed -- a level editor for Crimson Fields
   Copyright (C) 2000, 2001 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**************************************************
**  ed_list.h  -  linked lists header file
**************************************************/

#ifndef _INCLUDE_ED_LIST_H
#define _INCLUDE_ED_LIST_H

/* structure definitions */

struct Node {
	struct Node *ln_Next;
	struct Node *ln_Prev;
	void *ln_Data;
};


struct List {
	struct Node *lh_Head;
	struct Node *lh_Tail;
	struct Node *lh_TailPred;
};

/* function prototypes */
#define IsListEmpty(l)		((l)->lh_TailPred == (struct Node *)(l))

void NewList( struct List *l );
void AddHead( struct List *l, struct Node *n );
void AddTail( struct List *l, struct Node *n );
void Insert( struct List *l, struct Node *n, struct Node *after );
struct Node *RemHead( struct List *l );
struct Node *RemTail( struct List *l );
void Remove( struct Node *n );

#endif	/* _INCLUDE_ED_LIST_H */

