// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// font.h
//
// Changes:
///////////////////////////////////////////////////////////////

// proportional fonts not supported yet

#ifndef _INCLUDE_FONT_H
#define _INCLUDE_FONT_H

#include "surface.h"

#define FONT_CAPS_ONLY	0x01

class Font {
public:
  Font( SDL_RWops *file );
  ~Font( void ) { delete surface; }

  // returns max. character width for proportional fonts
  unsigned char Width( void ) const { return width; }
  unsigned char Height( void ) const { return height; }
  unsigned char CharWidth( char c ) const { return width; }
  unsigned short TextWidth( const char *str ) const;
  bool Allowed( unsigned short c ) const;

  void DisplayFormat( void ) { surface->DisplayFormat(); }

  void SetColor( const Color &fcol );
  void GetColor( Color &fcol ) const { fcol = col; }
  void Write( const char *str, Surface *dest, short x, short y ) const;
  void Write( char c, Surface *dest, short x, short y ) const;
  void Write( const char *str, Surface *dest, short x, short y, const Color &color );
  void Write( char c, Surface *dest, short x, short y, const Color &color );
  void Write( const char *str, Surface *dest, short x, short y, const Rect &clip ) const;

private:
  Surface *surface;
  unsigned char width;
  unsigned char height;
  unsigned char chars;		// number of characters
  unsigned char flags;

  Color col;
};

#endif	/* _INCLUDE_FONT_H */

