// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2005 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//////////////////////////////////////////////////////////////////////////
// unitwindow.h - the window classes used for getting unit specifications
//                and showing contents of buildings and transports
//////////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_UNITWINDOW_H
#define _INCLUDE_UNITWINDOW_H

#include "window.h"
#include "button.h"
#include "listselect.h"
#include "textbox.h"
#include "container.h"
#include "building.h"

class Game;
class MapWindow;
class UnitSet;
class TerrainSet;
class UnitListWidget;
class TransferScrollable;
class ULWNode;

// the same window class is used for buildings and transports

#define CW_MODE_NORMAL		0
#define CW_MODE_PRODUCTION	1
#define CW_MODE_TRANSFER	2

#define CH_NUM_BUTTONS		4

class ContainerWindow : public Window, public WidgetHook {
public:
  ContainerWindow( UnitContainer *container, View *view );
  ~ContainerWindow( void );

  GUI_Status HandleEvent( const SDL_Event &event );
  void SwitchMode( unsigned short newmode );
  GUI_Status SelectNode( ULWNode *node );

  unsigned short Mode( void ) const { return mode; }

  void Draw( void );
  void DrawCrystals( void );

  GUI_Status WidgetActivated( Widget *widget, Window *win );

private:
  UnitContainer *c;

  bool unit;                          // true if transport, false if building
  unsigned short mode;

  List normal;
  List build;
  Rect unitinfo;
  Image crystals_icon;

  UnitListWidget *listwidget;
  ButtonWidget *buttons[CH_NUM_BUTTONS];
  SliderWidget *slider;
  StringWidget *stringwidgets[2];
  TransferScrollable *transferscroll;

  Node *last_selected;
};


// unit type information window
class UnitInfoWindow : public Window {
public:
  UnitInfoWindow( const UnitType *type, MapWindow *mapwin,
                  View *view );

  void Draw( void );
  GUI_Status HandleEvent( const SDL_Event &event );

private:
  Rect image;
  Rect info;
  MapWindow *mw;
  const UnitType *unit;
  Surface *portrait;
};

#endif	/* _INCLUDE_UNITWINDOW_H */

