// Description:
//   Video subsystem.
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef _Video_hpp_
#define _Video_hpp_

#include <GLTexture.hpp>
#include <GLBitmapFont.hpp>
#include <TextInput.hpp>

#include <Singleton.hpp>

const int VIDEO_DEFAULT_WIDTH=640;
const int VIDEO_DEFAULT_HEIGHT=480;

const int VIDEO_ORTHO_WIDTH=1000;
const int VIDEO_ORTHO_HEIGHT=750;

class Video
{
friend class Singleton<Video>;
public:
    bool init( void);
    bool update( void);

    int getWidth( void) { return _width;}
    int getHeight( void) { return _height;}

    void toggleCritterBoard( void)
    {
	_boardVisible = !_boardVisible;
    }

    void takeSnapshot( void);

private:
    ~Video();
    Video( void);
    Video( const Video&);
    Video &operator=(const Video&);

    void reload( void);
    void updateSettings( void);
    bool setVideoMode( void);

    bool _isFullscreen;
    bool _showStarfield;

    int _bpp;
    int _width;
    int _height;

    GLBitmapFont *_smallFont;
    GLBitmapFont *_scoreFont;

    GLBitmapCollection *_board;
    int _boardIndex;
    bool _boardVisible;
    float _boardPosX;

    string _statusMsg;
    bool _statusMsgActive;
    float _statusMsgWidth;
    float _statusMsgPos;

    GLTexture *_titleA;
    GLTexture *_titleB;

    TextInput _textInput;
};

typedef Singleton<Video> VideoS;

#endif
