// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __Maze_hpp__
#define __Maze_hpp__

// Maze Class

//This base maze class privides only the actual maze 
//(to be thought of as a collection of walls) and some
//primitive info functions, all of which are inlined. 
//Note that the bit representation for the walls 
//(and other stuff) restricts what can be done in
//derived classes, since in the end everything has to
//fit into a 32-bit field.
//A better way might be to do the bit assignment at constructor time,
//oh well...

#include "SDL.h"

// element bit representation for walls
const Uint32 WallUP = 1 << 0;
const Uint32 WallDN = 1 << 1;
const Uint32 WallLT = 1 << 2;
const Uint32 WallRT = 1 << 3;

// element bit representation for other elements
const Uint32 ENEMY     = 1 << 4;
const Uint32 POINT     = 1 << 5;

//powerpoints make you stronger than the enemy
const Uint32 POWERPOINT= 1 << 6;

//not used...
const Uint32 GOODIE    = 1 << 7;
const Uint32 TRANSPORT = 1 << 8;

class Maze
{
protected:

    int *y2off;
    Uint32 *map;

    int width;
    int height;

    void Create( void);
    void Simplify( void);

public:

    Maze( int width, int height);

    ~Maze();

    int  Width( void){ return( width);}
    int  Height( void){ return( height);}

    bool isElement( int x, int y, Uint32 element)
    { 
	return( ( map[ y2off[ y] + x] & element) != 0);
    }

    void RemoveElement( int x, int y, Uint32 element)
    {
	map[ y2off[ y] + x] &= ~element;
    }

    void AddElement( int x, int y, Uint32 element)
    {
	map[ y2off[ y] + x] |= element;
    }
};

#endif
