// Description:
//   Singleton to Keep track of configurable values. 
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef _Config_hpp_
#define _Config_hpp_

#include <list>
#include <hashMap.hpp>
#include <string>

using namespace std;

#include <Value.hpp>
#include <Singleton.hpp>
#include <ConfigHandler.hpp>

#include <HashString.hpp>

const string CONFIGFILE = "ConfigFile";

class Config
{
friend class Singleton<Config>;
public:
    void updateFromCommandLine( int argc, char *argv[]);
    void updateFromFile( void);
    void updateKeyword( const char *keyword, const char *value);
    void updateKeyword( const string keyword, const string value);
    void updateKeyword( const string keyword, Value *value);
    void remove( const string &keyword);

    //when reading/writing the config file, registerd ConfigHandlers
    //will be notified (see ConfigHandler)
    void registerConfigHandler( ConfigHandler *ch)
    {
        _configHandlerList.insert( _configHandlerList.begin(), ch);
    }

    bool getString( const string &keyword, string &value);
    bool getInteger( const string &keyword, int &value);
    bool getFloat( const string &keyword, float &value);
    bool getBoolean( const string &keyword, bool &value);

    const string &getConfigFileName( void);

    void saveToFile( bool truncate=true);
    void dump( void);

private:
    ~Config();
    Config( void);
    Config( const Config&);
    Config &operator=(const Config&);

    list<ConfigHandler*> _configHandlerList;
    hash_map< string, Value*, hash<string> > _keyValueMap;
};

typedef Singleton<Config> ConfigS;

#endif
