.\"$Id: gcfclient.man,v 1.5 2001/11/05 08:09:46 mwedel Exp $
.TH gcfclient
.SH NAME
gcfclient - gtk client program for crossfire servers.
.SH SYNOPSIS
.B gcfclient 
[-server server] [-port number] [-display display] [-split|-nosplit]
[-echo] [-showicon] [-scrollines number] [-sync] [-help]
[-cache|-nocache] [-darkness|-nodarkness] [-nosound]
[-updatekeycodes] [-nopopups] [-splitinfo] [-mapsize xXy] [-sdl]
[-mapscale percentage] [-iconscale percentage] [-triminfo] [-timemapredraw]
.SH DESCRIPTION
.PP
.I gcflient
is an gtk program for connecting to crossfire servers.  Crossfire is a
multiplayer graphical adventure game that mixes aspects of Gauntlet (TM),
nethack, moria, and Ultima (TM).

This man page describes options for the gtk client of crossfire
(gcfclient).  Other clients of crossfire may not support all these options
or may support other options - man pages specific to those versions
should be referenced.

.SH OPTIONS
.TP
.B -cache|-nocache
Determines if the client will cache images for future runs.  With -nocache,
when the server is about to referance an image that the client has
yet to receive, it sends that image along to the client.  These downloaded
images are discarded once the client exists.  With -cache, the server
sends information about the image it is about to referance.  The client
can then check its local cache (stored in ~/.crossfire/images) - if it
has the image, it creates it off the disk.  If it does not have it,
it requests it from the server and then stores it in its cache.  In the
brief time between the request of the image and it actually receives it,
that image will be represented by a ? in the map.

-cache option is strongly recommended anytime when your link to the server
is slower than home directory access - this is likely to be the case
except in case of nfs mounted home directories on the server on the local
lan.

.TP
.B -darkness|-nodarkness
Controls whether the server sends darkness information to the client
or not.  Turning off darkness results in a savings off bandwidth
for maps that use darkness code (currently, very few maps use darkness
code).  Turning off darkness may also be desirable as in some graphics
mode the quality of darkness may not add much to the map.

.TP
.B -display <display>
The display to open the windows on.  If this option is not given, it
will use the DISPLAY environmental variable to determine the display.

.TP
.B -echo|-noecho
Echo commands as they are entered.  Normally, commands bound to keys
are just sent to the server without any echoing on the client of what
that command actually was.  This option causes the commands to also be
printed in the information window as they are sent to the server.

.TP
.B -fog
Enables fog of war code.  In this mode, spaces which have been seen
before but are no longer visible will still be shown on the game
window half darkened.  The data in these spaces is not up to date
since it is currently out of site.  This has no effect on bandwidth,
but may consume more cpu time.

.TP
.B -help
Prints out a brief description of the options to standard output.

.TP
.B -iconscale
Causes the images for the inventory icons 
to be scaled some percentage value.
Minimum value is 25%.  Setting this to 50% is
very useful - doubles amount of data visible in the inventory
window.

.TP
.B -keepcache
Causes the client not to download upated images from the server
if it already has an image of the same name previously cached.
By default, if the server has a newer image, the client will download
it and replace the cached version with it.  Using this option can be
useful if your cache has been populated with a set of images you
prefer over the one on the server, or if you play on multiple servers
and they have different image sets and you don't want to keep downloading
the images over and over again as you switch between servers.

.TP
.B -mapscale
Causes the images for the 
map surface (-mapscale) to be scaled some percentage value.
Minimum value is 25%.  This value does not need to be the same as
the iconscale value.  Scaling down the size of the map images can
be useful when playing on low resolution screens.  Smaller images
will also consume less cpu as it will be less information to draw.

.TP
.B -mapsize XxY
Sets the desired viewable map window.  X and Y are number of tiles.
Note that larger map sizes are likely to consume more bandwidth,
cpu time, as well as just screen real estate.

The maximum map size may vary server to server.  The client will
try to negotiate the largest viewable map in each dimension.  Note
that there is no requirement that the viewable map be square.

Due to performance issues, it is strongly suggested that expirementation
is done with this value to find a size that gets acceptable performance
n(simple test - go to the start town, run in some direction, stop
running and see how long it takes before the client stops moving
you).

.TP
.B -pngfile <file>
This can be used to have the client use an image file (format 
same as that on the server) to load images.  This option will likely
be obsoleted and instead replaced by images in local cache directories.

.TP
.B -popops|-nopopups
This enables/disables pop up windows that otherwise appear for certain input.
When disabled,  the input will be taken from text entries in the basic text
pane.  The default is that popups are enabled.

.TP
.B -port <number>
The port number of the server to connect to.  By default, it will use
port 13327 (standard port).  However, certain servers may use other
ports.

.TP
.B -sdl
This option will only be available if the SDL library was
available when the client was compiles. Using this option allows
for more complex graphics - true alpha channel, improved darkness
handling.  Performance may be worse
when using this option - this depends on many factors.  Like
the mapsize option above, it is suggested the experimentation is
done to make performance is still acceptable.  This option does
not affect bandwidth - it only affects cpu performance.  If this option
is not used, GdkPixmaps will be used instead.

.TP
.B -server <server>
Sets the server to play on.  If no option is given, it will default to
localhost.  

.TP
.B -showicon
This shows a little icon next to items in your inventory that contains
a brief description of some of the item properties (magic, cursed,
equipped, etc.)  This can make spotting some items easier, but some
players may not like the extra space these icons take up or the

.TP
.B -sound|-nosound
Enalbe/Disables sound effects.  Disabling sound has a minor savings on bandwidth.  It is
most useful if you do not want sound, due to lack of hardware or lack
of desire for sound.  Default is sound is enabled.

.TP
.B -split|-nosplit
-split starts the windows up in split windows mode.  In split windows
mode, 6 seperate windows are created - these individual windows can then
be moved around and resized as desired.  -nosplit starts the game up with
a single window - this is the default.  The option is useful if your
saved defaults are set for -split (see Saved Defaults further down).

.TP
.B -splitinfo
This splits the information pane window into two sub windows.  One contains
all the attack messages and otherwise fairly mundane information, and the
other contains important messages, like changes in protection values,
levels, etc.

.TP
.B -sync
Runs the server in synchronous display mode.  This option tends only to
be useful in debugging purposes - using this will slow down the display
and not gain anything for the typical player.

.TP
.B -timemapredraw
Prints out debugging time information to stderr.  This timing information
can be useful when trying to find performance problems, or just how
different client options change the time it takes for the map to get
drawn, which is the biggest cpu consumer in the client.

.TP
.B -triminfowindow | -notriminfowindw
Causes the information window to get 'trimmed', eg, remove text
so that the total contents of the information window remains
roughly the same size (20,000 bytes or so).  As of 2001-11-03,
using this option resulted in client periodically crashing.
The problem appears to be within gtk, so using this is not 
encouraged.  However, the problems in gtk may get fixed, or this
may be more reliable on other platforms so is included.

.TP
.B -updatekeycodes
The standard behaviour when a player uses the bind command to bind
new actions is that they keycode is saved with that binding.  Keycodes
are specific to keyboards - a sun keyboard will generate a different
keycode compared to a PC style keyboard.  In most cases, it is not
always desirable to have the keycodes get updated, as this may make
some bindings unavailable.  Using this option will force custom keybindings
to get updated for the current keyboard when the client is run.

.TP
.B -pix|-xpm|-png

These options are obsolete.  Currently, the client only supports
png graphics, and the other options are no longer valid.




.SH SAVED DEFAULTS

 Once you have logged into the server, you can enter extended commands
by typing ' (apostrophe) followed by the extended commands.  One of these
extended commands is savedefaults.  This will save many of
the options listed above.  Note that the saved defaults are
read first, so using the command line switches can be used to override
settings in the gdefaults file.

The settings are saved into 
~/.crossfire/gdefaults.

If you are using split windows mode, you can enter savewinpos
as an extended command.  This will save the current window positions
and sizes into ~/.crossfire/winpos.  Next time you run the server
in split mode, it will load these values and resize and move the windows
as specified.

.SH PLAYING WITH THE CLIENT

This is by far a complete tutorial of gameplay.  This section is to
provide a basic introduction to logging in and doing a few very
basic actions.

The first thing that will happen after the client successfully connects
to the server is you will be prompted for a name.  There are some
restrictions to the name you can choose, but alphanumeric characters
are all safe.

After entering the name, you will then be prompted for a password.  When
creating a new character, enter whatever you want your password to be.
If you get a 'login incorrect' someone else already has that character
name with a different password - try another name.  If no one has used
that name, you will be prompted for the password again to confirm it.

You now start the character creation process.  It is beyond the scope
of the document to fully describe the pros and cons of different
stats and classes.  The creation process has different options for
swapping stats and choosing a class.

Once you have chosen your class, you will be in the middle of a town.
The arrow keys will move you in the various directions.  There will be
a red building almost directly above you - this is the inn where you
save your character.  There are some signs to your right.  To read
them, move on top of them and press the 'a' key.  This applies the
object below you - in the case of signs, it reads it.  In the case of
buildings, it will cause you to enter the building.

To the left of the signs is a small building - this is the beginner
dungeon.  Enter it, and follow the directions on the signs.  It provides
a pretty good tutorial on some of the basic actions and features of
the game.

To enter extended commands, type the ' (apostrophe) followed by the
command.  An example would be 'help (apostrophe followed by the
help command).  Enter command to execute the command.

.SH USEFUL EXTENDED COMMANDS

.TP
.B savewinpos savedefaults
These commands were described in the SAVED DEFAULTS options above.

.TP
.B scroll
This toggles whether or the information windows scrolls when it gets to 
the bottom of the window or wraps to the top.  Wrapping is slighly less
cpu intensive, but is generally harder to read.

.TP
.B bind unbind
bind is used to add new keybindings.  Do you want to be able to press
one key to cast a fireball?  This is what the bind command does.
'help bind gives much more detailed information.  Once a command
is bound, it is stored in ~/.crossfire/keys and will be used in future
plays.
.TP
.B scroll
Cfclient only. Toggles between scroll and wrap mode.
In wrap mode, when text gets to the bottom of the
message window, it starts new messages at the top.
Scroll is only really useful on very slow systems where
the performance hit of scrolling the window is too costly.
.TP
.B magicmap
Displays the data from the last time the magic mapping
spell was cast.  This information can be completely useless
if you are now on another map.
.TP
.B cwindow <number>
Specifies the number of unprocessed commands to the server.
The server processes player commands as the character has
actions to perform them - having this number too high
can result in extended lengths of time that after you stop
entering commands the character is still performing actions.
Having this value too low on slow links can result in the
character sitting idle even though they have an action
comming to them.


.SH FILES
.TP
.B ~/.crossfire
This is a directory that is created that is used to store various
files.
.TP
.B ~/.crossfire/gdefaults
This contains default setttings.  This file can in theory be edited
by hand - just be careful to keep the same case and whitespace.
.TP
.B ~/.crossfire/images
This directory is used for the image cache if -cache is being used.
.TP
.B ~/.crossfire/keys
This contains keybindings you have edited.  This file can also be
theoretically edited - changing existing entries is much safer than
trying to figure out the syntax for new entries.
.TP
.B ~/.crossfire/winpos
Window positions and sizes to use in split window mode.  This file
can also be edited by hand.

.PP
Please let me know about any bugs you find in the client.
.SH AUTHOR
Copyright (C) 1994,2001 Mark Wedel & Crossfire Development Team
GTK port by David Sundqvist (azzie@netpolicy.com)
SDL support added by Scott MacFiggen (smurf@CSUA.Berkeley.EDU)

There are a great many other contributors to both the client and server
that are not mentioned here.

.ft R
.RE
.LP
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.

.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.

.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

.\" The author can be reached via e-mail to crossfire-devel@real-time.com
