!!! info 

    Please note that the `{{v1X.config.acquis_path}}` should be auto generated by the {{v1X.wizard.name}} in most case.

The acquisition configuration specifies lists of logs that {{v1X.crowdsec.name}} will ingest and feed to parsers.
Acquisition provides two information about a given log :

 - its source (a path to a file, or a journalctl filter)
 - its type, given in the form of a label

The `type` label is crucial as it's later used in the process to determine which parser(s) can handle lines coming from this source.

Acquisition can be found in `{{v1X.config.acquis_path}}`, for example :
<details>
  <summary>Acquisition example</summary>
```yaml
filenames:
  - /var/log/nginx/access-*.log
  - /var/log/nginx/error.log
labels:
  type: nginx
---
filenames:
  - /var/log/auth.log
labels:
  type: syslog
---
journalctl_filter:
 - "_SYSTEMD_UNIT=ssh.service"
labels:
  type: syslog
```
</details>


## Testing and viewing acquisition

### At startup

At startup, you will see the monitored files in `/var/log/crowdsec.log` :

```
...
INFO[23-11-2020 15:21:17] [file datasource] opening file '/tmp/test.log' 
WARN[23-11-2020 15:21:17] [file datasource] no results for /tmp/ratata.log 
INFO[23-11-2020 15:21:17] [journald datasource] Configured with filters : [--follow _SYSTEMD_UNIT=ssh.service] 
...
```

### At runtime

{{v1X.cli.name}} allows you to view {{v1X.crowdsec.name}} metrics info via the `metrics` command.
This allows you to see how many lines are coming from each source, and if they are parsed correctly.

You can see those metrics with the following command:
```
sudo {{v1X.cli.bin}} metrics
```


<details>
  <summary>{{v1X.cli.name}} metrics example</summary>

```bash
$ sudo {{v1X.cli.bin}} metrics
...
...
INFO[0000] Acquisition Metrics:     
+--------------------------------------+------------+--------------+----------------+------------------------+
|                SOURCE                | LINES READ | LINES PARSED | LINES UNPARSED | LINES POURED TO BUCKET |
+--------------------------------------+------------+--------------+----------------+------------------------+
| /tmp/test.log                        |         10 |           10 | -              |                     11 |
| journalctl-_SYSTEMD_UNIT=ssh.service |         36 |           12 |             24 |                     17 |
+--------------------------------------+------------+--------------+----------------+------------------------+
...
...
```

</details>


!!! info

    All these metrics are actually coming from {{v1X.crowdsec.name}}'s prometheus agent. See [prometheus](/Crowdsec/v1/observability/prometheus/) directly for more insights.


## Reference documentation

[Link to acquisition reference documentation](/Crowdsec/v1/references/acquisition/)
