/*
    Copyright (C) 2001 by Jorrit Tyberghein

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>
#include "cssysdef.h"
#include "csutil/cmdhelp.h"
#include "csutil/csevent.h"
#include "csutil/snprintf.h"
#include "iutil/objreg.h"
#include "iutil/cmdline.h"
#include "iutil/config.h"
#include "iutil/eventq.h"
#include "iutil/plugin.h"


void csCommandLineHelper::Help (iConfig* config)
{
  int i;
  for (i = 0 ; ; i++)
  {
    csOptionDescription option;
    if (!config->GetOptionDescription (i, &option))
      break;
    char opt [30], desc [80];
    csVariant def;
    config->GetOption (i, &def);
    switch (option.type)
    {
      case CSVAR_BOOL:
        sprintf (opt,  "  -[no]%s", option.name);
	sprintf (desc, "%s (%s) ", option.description, def.GetBool ()
		? "yes" : "no");
	break;
      case CSVAR_CMD:
        sprintf (opt, "  -%s", option.name);
	strcpy (desc, option.description);
	break;
      case CSVAR_FLOAT:
        sprintf (opt,  "  -%s=<val>", option.name);
	sprintf (desc, "%s (%g)", option.description, def.GetFloat ());
	break;
      case CSVAR_LONG:
        sprintf (opt,  "  -%s=<val>", option.name);
	sprintf (desc, "%s (%ld)", option.description, def.GetLong ());
	break;
      case CSVAR_STRING:
        sprintf (opt,  "  -%s=<val>", option.name);
	sprintf (desc, "%s (%s)", option.description, def.GetString ()
		? def.GetString () : "none");
	break;
    }
    //@@@????
    printf ("%-21s%s\n", opt, desc);
    //ReportSys (CS_MSG_STDOUT, "%-21s%s\n", opt, desc);
  }
}

void csCommandLineHelper::Help (iObjectRegistry* object_reg,
	iCommandLineParser* cmdline)
{
  if (!cmdline)
    cmdline = CS_QUERY_REGISTRY (object_reg, iCommandLineParser);
  else
    cmdline->IncRef ();
  CS_ASSERT (cmdline != NULL);

  // First send a global cscmdCommandLineHelp event.
  iEventQueue* evq = CS_QUERY_REGISTRY (object_reg, iEventQueue);
  if (evq)
  {
    iEventOutlet* evout = evq->GetEventOutlet ();
    evq->DecRef ();
    CS_ASSERT (evout != NULL);
    // We use ImmediateBroadcast here because after processing commandline
    // help the application usually exits. This means there is no chance
    // to actually process the event in the queue.
    evout->ImmediateBroadcast (cscmdCommandLineHelp, NULL);
  }

  iPluginManager* plgmgr = CS_QUERY_REGISTRY (object_reg, iPluginManager);
  int i;
  for (i = 0; i < plgmgr->GetPluginCount (); i++)
  {
    iBase* plug = plgmgr->GetPlugin (i);
    iConfig* config = SCF_QUERY_INTERFACE (plug, iConfig);
    if (config)
    {
      iFactory* fact = SCF_QUERY_INTERFACE (plug, iFactory);
      if (fact)
      {
        printf ("Options for %s:\n", fact->QueryDescription ());
	fact->DecRef ();
      }
      else
        printf ("Options for unknown plugin:\n");
      Help (config);
      config->DecRef ();
    }
  }
  plgmgr->DecRef ();
  cmdline->DecRef ();

  //@@@???
  printf (
"General options:\n"
"  -help              this help\n"
"  -video=<s>         the 3D rendering driver (opengl, software, ...)\n"
"  -canvas=<s>        the 2D canvas driver (asciiart, x2d, ...)\n"
"  -plugin=<s>        load the plugin after all others\n");
}

bool csCommandLineHelper::CheckHelp (iObjectRegistry* object_reg,
	iCommandLineParser* cmdline)
{
  if (!cmdline)
    cmdline = CS_QUERY_REGISTRY (object_reg, iCommandLineParser);
  else
    cmdline->IncRef ();
  CS_ASSERT (cmdline != NULL);
  bool rc = cmdline->GetOption ("help") != NULL;
  cmdline->DecRef ();
  return rc;
}

