/*  
    solarisAudio.h:

    Copyright (C) 1998 John ffitch, ????

    This file is part of Csound.

    The Csound Library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#ifndef solarisAudio
#define solarisAudio
#include <sys/audioio.h>
audio_info_t* audioGetDevInfo(int fd);
void audioSetDevInfo(int fd, audio_info_t* ai);
int audioGetPlayDevice(char *devName);
int audioGetRecordDevice(char *devName);
audio_prinfo_t audioGetPlayInfo(int fd);
audio_prinfo_t audioGetRecordInfo(int fd);
void audioSetPlayInfo(int fd, uint_t sampleRate, uint_t nOfChannels, uint_t precision, uint_t bufferSize);
void audioSetRecordInfo(int fd, uint_t sampleRate, uint_t nOfChannels, uint_t precision, uint_t bufferSize);
void audioPausePlay(int fd);
void audioResumePlay(int fd);
void audioPauseRecord(int fd);
void audioResumeRecord(int fd);
void audioPrintPlayInfo(int fd);
void audioPrintRecordInfo(int fd);
void audioPrintDevInfo(int fd);
void audioDie(int fd, char *message);
#endif
