
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: ifstmt.m,v 1.2 2000/08/12 15:27:22 stes Exp $
 */

#include <assert.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <Object.h>
#include "process.h"
#include "ifstmt.h"

id mkifstmt(id a,id b,id c)
{
  return [[[[IfStatement new] expr:a] thenexpr:b] elseexpr:c];
}

@implementation IfStatement

- expr:v
{
  expr = v; return self;
}

- thenexpr:v
{
  thenexpr = v; return self;
}

- elseexpr:v
{
  elseexpr = v; return self;
}

- go
{
  id e;
  int ok;
  int fd[2];

  [expr setsrcfd:srcfd];
  if (errbuf) [expr seterrbuf:errbuf]; else [expr seterrfd:errfd];
  if (dstbuf) [expr setdstbuf:dstbuf]; else [expr setdstfd:dstfd];

  [expr go];
  
  if ([expr exitcode] == 0) {
    e = thenexpr;
  } else {
    e = elseexpr;
  }

  if (makepipe) [e makepipe:makepipe];
  [e setsrcfd:srcfd];
  if (errbuf) [e seterrbuf:errbuf]; else [e seterrfd:errfd];
  if (dstbuf) [e setdstbuf:dstbuf]; else [e setdstfd:dstfd];
  [e go];
  exitcode = [e exitcode];
  if (makepipe) pipefd = [e pipefd];

  return self;
}

@end

