
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: process.h,v 1.3 2000/08/12 11:06:50 stes Exp $
 */


@interface Process : Object
{
  BOOL makepipe;
  BOOL background;
  int pid;
  int srcfd;
  int dstfd;
  int errfd;
  id  dstbuf;
  id  errbuf;
  int pipefd;
  id redirs;
  int exitcode;
}

- redir:x;
- openredirs;
- closeredirs;

- makepipe:(BOOL)flag;
- background:(BOOL)flag;

- setsigchldhandler;

- (int)pid;
- (int)exitcode;

- (int)srcfd;
- (int)dstfd;
- (int)errfd;
- (int)pipefd;
- dstbuf;
- errbuf;

- setsrcfd:(int)fd;
- setdstfd:(int)fd;
- seterrfd:(int)fd;
- setdstbuf:x;
- seterrbuf:x;

- dstwrite:(char*)s;
- errwrite:(char*)s;

- go;

@end
 
