%define confdir %{_sysconfdir}/cvsgraph

Name: cvsgraph
Version: 1.6.1
Release: 1
Summary: Create graphs of branches and revisions for files in a CVS repository
License: GPL
URL: http://www.akhphd.au.dk/~bertho/cvsgraph/
Group: Applications/Publishing
Source0: http://www.akhphd.au.dk/~bertho/cvsgraph/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
BuildRequires: gd freetype libjpeg libpng zlib
Requires: gd freetype libjpeg libpng zlib

%description
CvsGraph is a utility to make a graphical representation of all revisions
and branches of a file in a CVS/RCS repository. It has been inspired by
the 'graph' option in WinCVS, but I could not find a stand-alone version
of this graph code. So, it was time to write one.

%prep
[ "$RPM_BUILD_ROOT" != "/" ] && /bin/rm -rf $RPM_BUILD_ROOT

%setup

%build
./configure --sysconfdir=%{confdir}
make

%install
install -d -m 755 $RPM_BUILD_ROOT%{_bindir}
install -d -m 755 $RPM_BUILD_ROOT%{_mandir}/{man1,man5}
install -d -m 755 $RPM_BUILD_ROOT%{confdir}
install -m 755 $RPM_BUILD_DIR/%{name}-%{version}/%{name} $RPM_BUILD_ROOT%{_bindir}
install -m 644 $RPM_BUILD_DIR/%{name}-%{version}/%{name}.conf $RPM_BUILD_ROOT%{confdir}
install -m 644 $RPM_BUILD_DIR/%{name}-%{version}/%{name}.1 $RPM_BUILD_ROOT%{_mandir}/man1
install -m 644 $RPM_BUILD_DIR/%{name}-%{version}/%{name}.conf.5 $RPM_BUILD_ROOT%{_mandir}/man5

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%config(noreplace) %{confdir}/%{name}.conf
%dir %{confdir}
%{_bindir}/%{name}
%{_mandir}/man1/*
%{_mandir}/man5/*
%doc ChangeLog contrib/cvsgraphwrapper.php3 LICENSE contrib/mkimage.php3 README
%doc -P contrib/automatic_documentation/

%changelog
* Sat Jul 08 2006 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Minor bugfix, version number to 1.6.1
* Tue Dec 18 2005 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Major extension, version number to 1.6.0
* Tue Jun 14 2005 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Minor fixes, version number to 1.5.2
* Thu Oct 23 2004 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Up the version number to 1.5.1 and include contributions
* Thu Aug 15 2004 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Up the version number to 1.5.0
* Thu Aug 05 2004 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Up the version number for upcoming release (never released)
* Mon Jul 19 2004 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Update for version 1.4.1 and fix the version number
* Wed Mar 19 2003 Jason Corley <jason.corley@borland.com>
- Documentation and other aesthetic related fixes
* Mon Mar 17 2003 Bertho Stultiens <cvsgraph@akhphd.au.dk>
- Update for version 1.4.0
* Mon Feb 24 2003 Jason Corley <jason.corley@borland.com>
- Initial creation
