#!/usr/bin/perl -w

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use File::Compare;
use File::Slurp;
use strict;


my $tmp1 = init_tmp_repo();

mkpath 'dir';
write_file('dir/foo',"zig") || diag $!;

darcs('add dir dir/foo');
ok( (darcs 'record -a -m add_foo'), "recorded");

# Create second repo inside the first
darcs('init --repodir=tmp2');
chdir  'tmp2';

ok((darcs "pull -a ../../$tmp1"), "pull -a succeeds");

like( darcs('changes -s'), qr{A ./dir/foo}, "darcs changes shows expected output");

ok( (compare("../../$tmp1/dir/foo","dir/foo") == 0), "first and second directories are the same");
