#!/usr/bin/env perl

# Test that _darcs/prefs/binaries

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use strict;
use warnings;
use Shell::Command;
use File::Slurp;

{
    my $test = 'binary pattern matches against full path';
    init_tmp_repo();
    ok(mkpath('d'), "d created");
    touch 'd/t.t';
    darcs 'add d/t.t';
    darcs 'record -am "initial record"';
    append_file 'd/t.t','some change' ;

    my $out =  echo_to_darcs 'record --interactive', 'n' ;
    unlike($out, qr/binary/, "pre-test: plain text files are not binary"); 

    append_file '_darcs/prefs/binaries','d/t' ;

    # we want to see if darcs reports the file as binary or not
    $out =  echo_to_darcs 'record --interactive', 'n' ;
    like($out, qr/binary/, $test); 
}
