/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class NumberFn
extends SystemFunction {
    public Expression simplify() throws XPathException {
        this.useContextItemAsDefault();
        return this.simplifyArguments();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        if (item == null) {
            return DoubleValue.NaN;
        }
        if (item instanceof BooleanValue || item instanceof NumericValue) {
            return ((AtomicValue)item).convert(517);
        }
        String string = item.getStringValue();
        try {
            return new DoubleValue(Value.stringToNumber(string));
        }
        catch (NumberFormatException numberFormatException) {
            return DoubleValue.NaN;
        }
    }

    public static DoubleValue convert(AtomicValue atomicValue) {
        try {
            if (atomicValue == null) {
                return DoubleValue.NaN;
            }
            if (atomicValue instanceof BooleanValue || atomicValue instanceof NumericValue) {
                return (DoubleValue)atomicValue.convert(517);
            }
            String string = atomicValue.getStringValue();
            return new DoubleValue(Value.stringToNumber(string));
        }
        catch (NumberFormatException numberFormatException) {
            return DoubleValue.NaN;
        }
        catch (XPathException xPathException) {
            return DoubleValue.NaN;
        }
    }
}

