/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.text.Collator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.GroupAdjacentIterator;
import net.sf.saxon.sort.GroupByIterator;
import net.sf.saxon.sort.GroupEndingIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.GroupStartingIterator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedGroupIterator;

public class ForEachGroup
extends Instruction {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private Expression select = null;
    private byte algorithm;
    private Object key;
    private Collator collator = null;
    private SortKeyDefinition[] sortKeys = null;

    public ForEachGroup(Expression expression, byte by, Object object, Collator collator, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.algorithm = by;
        this.key = object;
        this.collator = collator;
        this.sortKeys = sortKeyDefinitionArray;
    }

    public String getInstructionName() {
        return "for-each-group";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Object object;
        Object object2;
        GroupIterator groupIterator;
        Controller controller = xPathContext.getController();
        GroupIterator groupIterator2 = controller.getCurrentGroupIterator();
        SequenceIterator sequenceIterator = controller.getCurrentIterator();
        Template template = controller.getCurrentTemplate();
        controller.setCurrentTemplate(null);
        SequenceIterator sequenceIterator2 = this.select.iterate(xPathContext);
        switch (this.algorithm) {
            case 0: {
                XPathContext xPathContext2 = xPathContext.newContext();
                xPathContext2.setCurrentIterator(sequenceIterator2);
                groupIterator = new GroupByIterator(sequenceIterator2, (Expression)this.key, xPathContext2, this.collator);
                break;
            }
            case 1: {
                XPathContext xPathContext3 = xPathContext.newContext();
                xPathContext3.setCurrentIterator(sequenceIterator2);
                groupIterator = new GroupAdjacentIterator(sequenceIterator2, (Expression)this.key, xPathContext3, this.collator);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(sequenceIterator2, (Pattern)this.key, xPathContext.getController());
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(sequenceIterator2, (Pattern)this.key, xPathContext.getController());
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.sortKeys != null) {
            object2 = new FixedSortKeyDefinition[this.sortKeys.length];
            object = controller.newXPathContext();
            int n = 0;
            while (n < this.sortKeys.length) {
                object2[n] = this.sortKeys[n].reduce((XPathContext)object);
                ++n;
            }
            groupIterator = new SortedGroupIterator((XPathContext)object, groupIterator, (FixedSortKeyDefinition[])object2);
        }
        controller.setCurrentIterator(groupIterator);
        controller.setCurrentGroupIterator(groupIterator);
        object2 = xPathContext.newContext();
        ((XPathContext)object2).setCurrentIterator(groupIterator);
        if (controller.isTracing()) {
            Item item;
            object = controller.getTraceListener();
            while ((item = groupIterator.next()) != null) {
                object.startCurrentItem(item);
                this.processChildren((XPathContext)object2);
                object.endCurrentItem(item);
            }
        } else {
            while ((object = groupIterator.next()) != null) {
                this.processChildren((XPathContext)object2);
            }
        }
        controller.setCurrentGroupIterator(groupIterator2);
        controller.setCurrentIterator(sequenceIterator);
        controller.setCurrentTemplate(template);
        return null;
    }
}

