/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.tree.AttributeCollection;

public class XSLPreserveSpace
extends StyleElement {
    private String elements;

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "elements") {
                this.elements = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.elements == null) {
            this.reportAbsence("elements");
            this.elements = "*";
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        Boolean bl = new Boolean(this.getFingerprint() == 172);
        Mode mode = this.getPrincipalStyleSheet().getStripperRules();
        StringTokenizer stringTokenizer = new StringTokenizer(this.elements);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                String string2;
                String string3;
                NodeTest nodeTest;
                if (string.equals("*")) {
                    nodeTest = AnyNodeTest.getInstance();
                    mode.addRule(nodeTest, bl, this.getPrecedence(), -0.5);
                } else if (string.endsWith(":*")) {
                    if (string.length() == 2) {
                        this.compileError("No prefix before ':*'");
                    }
                    string3 = string.substring(0, string.length() - 2);
                    string2 = this.getURIForPrefix(string3, false);
                    nodeTest = new NamespaceTest(this.getTargetNamePool(), 1, string2);
                    mode.addRule(nodeTest, bl, this.getPrecedence(), -0.25);
                } else if (string.startsWith("*:")) {
                    if (string.length() == 2) {
                        this.compileError("No local name after '*:'");
                    }
                    string3 = string.substring(2);
                    nodeTest = new LocalNameTest(this.getTargetNamePool(), 1, string3);
                    mode.addRule(nodeTest, bl, this.getPrecedence(), -0.25);
                } else {
                    Object object;
                    string2 = null;
                    String string4 = null;
                    try {
                        object = Name.getQNameParts(string);
                        string3 = object[0];
                        string4 = this.getURIForPrefix(string3, false);
                        string2 = object[1];
                    }
                    catch (QNameException qNameException) {
                        this.compileError("Element name " + string + " is not a valid QName");
                    }
                    object = this.getTargetNamePool();
                    int n = ((NamePool)object).allocate("", string4, string2);
                    nodeTest = new NameTest(1, n);
                    mode.addRule(nodeTest, bl, this.getPrecedence(), 0.0);
                }
                nodeTest.setOriginalText(string);
                nodeTest.setSystemId(this.getSystemId());
                nodeTest.setLineNumber(this.getLineNumber());
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
        }
        return null;
    }
}

