/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.FacetCollection;
import net.sf.saxon.type.SchemaMarker;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.XPathException;

public abstract class SimpleType
extends SchemaType {
    private FacetCollection facets;

    public final boolean isSimpleType() {
        return true;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public Iterator iterateMemberTypes() {
        return null;
    }

    public void setFacetCollection(FacetCollection facetCollection) {
        this.facets = facetCollection;
    }

    public FacetCollection getFacetCollection() {
        return this.facets;
    }

    public Facet getFacet(String string) {
        if (this.facets == null) {
            return null;
        }
        return this.facets.getFacet(string);
    }

    public Iterator getFacets(String string) {
        if (this.facets == null) {
            SchemaType schemaType = this.getBaseType();
            if (schemaType instanceof SimpleType && this.getDerivationMethod() != 8) {
                return ((SimpleType)schemaType).getFacets(string);
            }
            return Collections.EMPTY_LIST.iterator();
        }
        return this.facets.getFacets(string);
    }

    public Iterator getFacets() {
        if (this.facets == null) {
            if (this.getDerivationMethod() == 8) {
                return Collections.EMPTY_LIST.iterator();
            }
            SchemaType schemaType = this.getBaseType();
            if (schemaType instanceof SimpleType) {
                return ((SimpleType)schemaType).getFacets();
            }
            return Collections.EMPTY_LIST.iterator();
        }
        return this.facets.getFacets();
    }

    public int getWhitespaceAction() {
        int n = -1;
        Iterator iterator = this.getFacets("whiteSpace");
        if (iterator != null) {
            while (iterator.hasNext()) {
                Facet facet = (Facet)iterator.next();
                int n2 = facet.getWhitespaceAction();
                if (n2 <= n) continue;
                n = n2;
            }
        }
        if (n == -1) {
            if (this instanceof AtomicType && ((AtomicType)this).getPrimitiveType() == 513) {
                return 0;
            }
            return 2;
        }
        return n;
    }

    public CharSequence applyWhitespaceNormalization(CharSequence charSequence) {
        int n = this.getWhitespaceAction();
        switch (n) {
            case 0: {
                return charSequence;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(charSequence.length());
                int n2 = 0;
                while (n2 < charSequence.length()) {
                    if ("\n\r\t".indexOf(charSequence.charAt(n2)) >= 0) {
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append(charSequence.charAt(n2));
                    }
                    ++n2;
                }
                return stringBuffer;
            }
            case 2: {
                return NormalizeSpace.normalize(charSequence.toString());
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public SimpleType getBuiltInBaseType() {
        SimpleType simpleType = this;
        while (simpleType != null && simpleType.getFingerprint() > 1023) {
            simpleType = (SimpleType)simpleType.getBaseType();
        }
        return simpleType;
    }

    public boolean isNamespaceSensitive() {
        SimpleType simpleType = this;
        int n = simpleType.getFingerprint();
        while (simpleType != null && n > 1023) {
            simpleType = (SimpleType)simpleType.getBaseType();
            n = simpleType.getFingerprint();
        }
        return n == 530 || n == 531;
    }

    public String isTypeDerivationOK(SimpleType simpleType, int n) {
        if (this == simpleType) {
            return null;
        }
        if ((n & 1) != 0) {
            return "Simple type derivation is not OK: 'restriction' is in the set of disallowed derivations";
        }
        SchemaType schemaType = this.getBaseType();
        if (schemaType != null & !schemaType.allowsDerivation(1)) {
            return "Simple type derivation is not OK: the base type of " + this.getDescription() + " does not allow derivation by restriction";
        }
        if (schemaType == simpleType) {
            return null;
        }
        String string = null;
        if (schemaType != null && schemaType != BuiltInSchemaFactory.getSchemaType(593)) {
            if (!(schemaType instanceof SimpleType)) {
                return "Base type of " + this.getDescription() + " is not a simple type";
            }
            string = ((SimpleType)schemaType).isTypeDerivationOK(simpleType, n);
            if (string == null) {
                return null;
            }
        }
        if ((this.isListType() || this.isUnionType()) && simpleType == BuiltInSchemaFactory.getSchemaType(593)) {
            return null;
        }
        if (simpleType.isUnionType()) {
            Iterator iterator = simpleType.iterateMemberTypes();
            while (iterator.hasNext()) {
                SimpleType simpleType2 = (SimpleType)iterator.next();
                if (this.isTypeDerivationOK(simpleType2, n) != null) continue;
                return null;
            }
        }
        return this.getDescription() + " is not validly derived from " + simpleType.getDescription();
    }

    public boolean validate(SchemaMarker schemaMarker) throws TransformerException {
        if (this.getFingerprint() < 1023) {
            return true;
        }
        if (this.getBaseType() == null) {
            this.setBaseType(BuiltInSchemaFactory.getSchemaType(593));
        } else if (this.getBaseType() instanceof SimpleType) {
            ((SimpleType)this.getBaseType()).validate(schemaMarker);
        } else if (!this.getBaseType().isSimpleType()) {
            schemaMarker.error("The base type of the simple type " + this.getDescription() + " is not a simple type", this);
            return false;
        }
        return true;
    }

    public abstract void validateContent(CharSequence var1, NamespaceResolver var2) throws ValidationException;

    public final SequenceIterator getTypedValue(NodeInfo nodeInfo) throws XPathException {
        try {
            return this.getTypedValue(nodeInfo.getStringValue(), nodeInfo);
        }
        catch (ValidationException validationException) {
            throw new XPathException.Dynamic("Value doesn't match its type annotation. " + validationException.getMessage());
        }
    }

    public abstract SequenceIterator getTypedValue(CharSequence var1, NodeInfo var2) throws ValidationException;
}

