/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Header
{
	public class IdentityTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase, Db4oUnit.Extensions.Fixtures.IOptOutCS
	{
		public static void Main(string[] arguments)
		{
			new Db4objects.Db4o.Tests.Common.Header.IdentityTestCase().RunSolo();
		}

		public virtual void TestIdentityPreserved()
		{
			Db4objects.Db4o.Ext.Db4oDatabase ident = Db().Identity();
			Reopen();
			Db4objects.Db4o.Ext.Db4oDatabase ident2 = Db().Identity();
			Db4oUnit.Assert.IsNotNull(ident);
			Db4oUnit.Assert.AreEqual(ident, ident2);
		}

		public virtual void TestGenerateIdentity()
		{
			byte[] oldSignature = Db().Identity().GetSignature();
			GenerateNewIdentity();
			Reopen();
			Db4oUnit.ArrayAssert.AreNotEqual(oldSignature, Db().Identity().GetSignature());
		}

		private void GenerateNewIdentity()
		{
			((Db4objects.Db4o.Internal.LocalObjectContainer)Db()).GenerateNewIdentity();
		}
	}
}
