import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.view.JasperViewer;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.Db4oException;
import com.db4o.query.Predicate;

public class JasperReportsExample {
	private final static String DB4O_FILE_NAME = "reference.db4o";

	private final static int OBJECT_COUNT = 10;

	private static ObjectContainer _container = null;

	public static void main(String[] args) {
		storePilots();
		pilotsReport();
	}

	private static ObjectContainer database() {
		if (_container == null) {
			try {
				_container = Db4o.openFile(DB4O_FILE_NAME);
			} catch (DatabaseFileLockedException ex) {
				System.out.println(ex.getMessage());
			}
		}
		return _container;
	}

	// end database

	private static void closeDatabase() {
		if (_container != null) {
			_container.close();
			_container = null;
		}
	}

	// end closeDatabase

	private static void storePilots() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				Pilot pilot;
				for (int i = 0; i < OBJECT_COUNT; i++) {
					pilot = new Pilot("Test Pilot #" + i, i);
					container.set(pilot);
				}
				for (int i = 0; i < OBJECT_COUNT; i++) {
					pilot = new Pilot("Professional Pilot #" + (i + 10), i + 10);
					container.set(pilot);
				}
				container.commit();
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}

	// end storePilots

	public static void pilotsReport() {

		// obtain a list of objects for the report
		List<Pilot> pilots = database().query(new Predicate<Pilot>() {
			public boolean match(Pilot pilot) {
				// each Pilot is included in the result
				return true;
			}
		});

		// pass parameters to the report
		Map parameters = new HashMap();
		parameters.put("Title", "The Pilot Report");

		try {
			// compile report design
			JasperReport jasperReport = JasperCompileManager
					.compileReport("reports/the-pilot-report.jrxml");
			
			// create an object datasourse from the pilots list
			ObjectDataSource dataSource = new ObjectDataSource(pilots);

			// fill the report 
			JasperPrint jasperPrint = JasperFillManager.fillReport(
					jasperReport, parameters, dataSource);
			
			// export result to the *.pdf
			JasperExportManager.exportReportToPdfFile(jasperPrint,
					"reports/the-pilot-report.pdf");
			
			// or export to *.html
			JasperExportManager.exportReportToHtmlFile(jasperPrint,
			"reports/the-pilot-report.html");

			// or view it immediately in the Jasper Viewer
			JasperViewer.viewReport(jasperPrint);
		} catch (JRException e) {
			e.printStackTrace();
		}
	}
	// end pilotsReport
}