using System;
using System.IO;

using Db4objects.Db4o;
using Db4objects.Db4o.Query;


namespace Db4objects.Db4odoc.MonoTest
{

    public class MonoTest
    {
        private const string Db4oFileName = "test.db4o";

        public static void Main(string[] args)
        {
            File.Delete(Db4oFileName);
            IObjectContainer db = Db4oFactory.OpenFile(Db4oFileName);
            try
            {
                Pilot pilot1 = new Pilot("Michael Schumacher", 100);
                db.Set(pilot1);
                Console.WriteLine("Stored {0}", pilot1);
            }
            finally
            {
                db.Close();
            }
            db = Db4oFactory.OpenFile(Db4oFileName);
            try
            {
                IObjectSet result = db.Get(typeof(Pilot));
                ListResult(result);
            }
            finally
            {
                db.Close();
            }
        }
        // end Main

        private static void ListResult(IObjectSet result)
        {
            System.Console.WriteLine(result.Count);
            for (int i = 0; i < result.Count; i++)
            {
                System.Console.WriteLine(result[i]);
            }
        }
        // end ListResult


        class Pilot
        {
            private string _name;
            private int _points;

            public Pilot(string name, int points)
            {
                _name = name;
                _points = points;
            }

            public string Name
            {
                get
                {
                    return _name;
                }
                set
                {
                    _name = value;
                }
            }

            public int Points
            {
                get
                {
                    return _points;
                }
            }

            public override string ToString()
            {
                return string.Format("{0}/{1}", _name, _points);
            }
        }

    }
}
