/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using System.Collections;
using Db4oUnit;

namespace Db4oUnit
{
	public class TestRunner
	{
		private readonly IEnumerable _tests;

		public TestRunner(IEnumerable tests)
		{
			_tests = tests;
		}

		public virtual void Run(ITestListener listener)
		{
			listener.RunStarted();
			IEnumerator iterator = _tests.GetEnumerator();
			while (iterator.MoveNext())
			{
				ITest test = (ITest)iterator.Current;
				listener.TestStarted(test);
				try
				{
					test.Run();
				}
				catch (TestException x)
				{
					Exception reason = x.GetReason();
					listener.TestFailed(test, reason == null ? x : reason);
				}
				catch (Exception failure)
				{
					listener.TestFailed(test, failure);
				}
			}
			listener.RunFinished();
		}
	}
}
