/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using System.Collections;
using Db4oUnit;
using Db4objects.Db4o.Tests.Common.Foundation;

namespace Db4objects.Db4o.Tests.Common.Foundation
{
	public class AllTests : ITestSuiteBuilder
	{
		public virtual IEnumerator GetEnumerator()
		{
			return new ReflectionTestSuiteBuilder(new Type[] { typeof(Algorithms4TestCase), typeof(
				ArrayIterator4TestCase), typeof(Arrays4TestCase), typeof(BitMap4TestCase), typeof(
				BlockingQueueTestCase), typeof(Collection4TestCase), typeof(CompositeIterator4TestCase
				), typeof(DynamicVariableTestCase), typeof(CoolTestCase), typeof(Hashtable4TestCase
				), typeof(IntArrayListTestCase), typeof(IntMatcherTestCase), typeof(Iterable4AdaptorTestCase
				), typeof(IteratorsTestCase), typeof(NoDuplicatesQueueTestCase), typeof(NonblockingQueueTestCase
				), typeof(Path4TestCase), typeof(SortedCollection4TestCase), typeof(Stack4TestCase
				), typeof(TreeKeyIteratorTestCase), typeof(TreeNodeIteratorTestCase), typeof(BufferTestCase
				) }).GetEnumerator();
		}

		public static void Main(string[] args)
		{
			new ConsoleTestRunner(typeof(Db4objects.Db4o.Tests.Common.Foundation.AllTests)).Run
				();
		}
	}
}
