/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using System.IO;
using Db4oUnit;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Foundation;
using Db4objects.Db4o.Foundation.IO;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Internal.Activation;
using Db4objects.Db4o.Internal.Delete;
using Db4objects.Db4o.Internal.Handlers;
using Db4objects.Db4o.Internal.Marshall;
using Db4objects.Db4o.Marshall;
using Db4objects.Db4o.Tests.Common.Migration;
using Db4objects.Db4o.Typehandlers;

namespace Db4objects.Db4o.Tests.Common.Migration
{
	public class FieldsToTypeHandlerMigrationTestCase : ITestLifeCycle
	{
		public class Item
		{
			public Item(int id)
			{
				_id = id;
			}

			public int _id;
		}

		private string _fileName;

		internal FieldsToTypeHandlerMigrationTestCase.ItemTypeHandler _typeHandler;

		public class ItemTypeHandler : ITypeHandler4, IFirstClassHandler, IVariableLengthTypeHandler
		{
			private int _writeCalls;

			private int _readCalls;

			public virtual void Defragment(IDefragmentContext context)
			{
				throw new NotImplementedException();
			}

			/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
			public virtual void Delete(IDeleteContext context)
			{
				throw new NotImplementedException();
			}

			public virtual object Read(IReadContext context)
			{
				_readCalls++;
				FieldsToTypeHandlerMigrationTestCase.Item item = (FieldsToTypeHandlerMigrationTestCase.Item
					)((UnmarshallingContext)context).PersistentObject();
				item._id = context.ReadInt() - 42;
				return item;
			}

			public virtual void Write(IWriteContext context, object obj)
			{
				_writeCalls++;
				FieldsToTypeHandlerMigrationTestCase.Item item = (FieldsToTypeHandlerMigrationTestCase.Item
					)obj;
				context.WriteInt(item._id + 42);
			}

			public virtual IPreparedComparison PrepareComparison(IContext context, object obj
				)
			{
				throw new NotImplementedException();
			}

			public virtual void CascadeActivation(ActivationContext4 context)
			{
				throw new NotImplementedException();
			}

			public virtual void CollectIDs(QueryingReadContext context)
			{
				throw new NotImplementedException();
			}

			public virtual ITypeHandler4 ReadCandidateHandler(QueryingReadContext context)
			{
				throw new NotImplementedException();
			}

			public virtual int WriteCalls()
			{
				return _writeCalls;
			}

			public virtual int ReadCalls()
			{
				return _readCalls;
			}

			public virtual void Reset()
			{
				_writeCalls = 0;
				_readCalls = 0;
			}
		}

		/// <exception cref="System.Exception"></exception>
		public virtual void SetUp()
		{
			_fileName = Path.GetTempFileName();
			File4.Delete(_fileName);
		}

		/// <exception cref="System.Exception"></exception>
		public virtual void TearDown()
		{
			File4.Delete(_fileName);
		}

		public virtual void TestMigration()
		{
			_typeHandler = null;
			Store(new FieldsToTypeHandlerMigrationTestCase.Item(42));
			FieldsToTypeHandlerMigrationTestCase.Item item = RetrieveOnlyItemInstance();
			Assert.AreEqual(42, item._id);
			AssertItemStoredField(42);
			_typeHandler = new FieldsToTypeHandlerMigrationTestCase.ItemTypeHandler();
			item = RetrieveOnlyItemInstance();
			Assert.AreEqual(42, item._id);
			AssertTypeHandlerCalls(0, 0);
			AssertItemStoredField(42);
			UpdateItem();
			AssertTypeHandlerCalls(1, 0);
			AssertItemStoredField(null);
			item = RetrieveOnlyItemInstance();
			Assert.AreEqual(42, item._id);
			AssertTypeHandlerCalls(0, 1);
			AssertItemStoredField(null);
		}

		public virtual void TestTypeHandler()
		{
			_typeHandler = new FieldsToTypeHandlerMigrationTestCase.ItemTypeHandler();
			Store(new FieldsToTypeHandlerMigrationTestCase.Item(42));
			AssertTypeHandlerCalls(1, 0);
			FieldsToTypeHandlerMigrationTestCase.Item item = RetrieveOnlyItemInstance();
			Assert.AreEqual(42, item._id);
			AssertTypeHandlerCalls(0, 1);
			UpdateItem();
			AssertTypeHandlerCalls(1, 1);
		}

		private void AssertItemStoredField(object expectedValue)
		{
			IObjectContainer db = OpenContainer();
			try
			{
				IObjectSet objectSet = db.Query(typeof(FieldsToTypeHandlerMigrationTestCase.Item)
					);
				Assert.AreEqual(1, objectSet.Size());
				FieldsToTypeHandlerMigrationTestCase.Item item = (FieldsToTypeHandlerMigrationTestCase.Item
					)objectSet.Next();
				IStoredField storedField = db.Ext().StoredClass(typeof(FieldsToTypeHandlerMigrationTestCase.Item
					)).StoredField("_id", null);
				object actualValue = storedField.Get(item);
				Assert.AreEqual(expectedValue, actualValue);
			}
			finally
			{
				db.Close();
			}
		}

		private void AssertTypeHandlerCalls(int writeCalls, int readCalls)
		{
			Assert.AreEqual(writeCalls, _typeHandler.WriteCalls());
			Assert.AreEqual(readCalls, _typeHandler.ReadCalls());
		}

		private FieldsToTypeHandlerMigrationTestCase.Item RetrieveOnlyItemInstance()
		{
			IObjectContainer db = OpenContainer();
			try
			{
				IObjectSet objectSet = db.Query(typeof(FieldsToTypeHandlerMigrationTestCase.Item)
					);
				Assert.AreEqual(1, objectSet.Size());
				FieldsToTypeHandlerMigrationTestCase.Item item = (FieldsToTypeHandlerMigrationTestCase.Item
					)objectSet.Next();
				return item;
			}
			finally
			{
				db.Close();
			}
		}

		private void Store(FieldsToTypeHandlerMigrationTestCase.Item item)
		{
			IObjectContainer db = OpenContainer();
			try
			{
				db.Store(item);
			}
			finally
			{
				db.Close();
			}
		}

		private void UpdateItem()
		{
			IObjectContainer db = OpenContainer();
			try
			{
				IObjectSet objectSet = db.Query(typeof(FieldsToTypeHandlerMigrationTestCase.Item)
					);
				db.Store(objectSet.Next());
			}
			finally
			{
				db.Close();
			}
		}

		private IObjectContainer OpenContainer()
		{
			if (_typeHandler != null)
			{
				_typeHandler.Reset();
			}
			IConfiguration configuration = Db4oFactory.NewConfiguration();
			if (_typeHandler != null)
			{
				configuration.RegisterTypeHandler(new SingleClassTypeHandlerPredicate(typeof(FieldsToTypeHandlerMigrationTestCase.Item
					)), _typeHandler);
			}
			IObjectContainer db = Db4oFactory.OpenFile(configuration, _fileName);
			return db;
		}

		public virtual void Defragment(IDefragmentContext context)
		{
		}

		// TODO Auto-generated method stub
		/// <exception cref="Db4objects.Db4o.Ext.Db4oIOException"></exception>
		public virtual void Delete(IDeleteContext context)
		{
		}

		// TODO Auto-generated method stub
		public virtual object Read(IReadContext context)
		{
			// TODO Auto-generated method stub
			return null;
		}

		public virtual void Write(IWriteContext context, object obj)
		{
		}

		// TODO Auto-generated method stub
		public virtual IPreparedComparison PrepareComparison(IContext context, object obj
			)
		{
			// TODO Auto-generated method stub
			return null;
		}
	}
}
